/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy;

import com.google.common.collect.ImmutableMap;
import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovy.xml.MarkupBuilder;
import java.util.Map;
import ratpack.func.Action;
import ratpack.func.Function;
import ratpack.groovy.guice.GroovyBindingsSpec;
import ratpack.groovy.handling.GroovyChain;
import ratpack.groovy.handling.GroovyChainAction;
import ratpack.groovy.handling.GroovyContext;
import ratpack.groovy.handling.internal.ClosureBackedHandler;
import ratpack.groovy.handling.internal.DefaultGroovyChain;
import ratpack.groovy.handling.internal.DefaultGroovyContext;
import ratpack.groovy.handling.internal.GroovyDslChainActionTransformer;
import ratpack.groovy.internal.ClosureInvoker;
import ratpack.groovy.internal.ClosureUtil;
import ratpack.groovy.internal.RatpackScriptBacking;
import ratpack.groovy.markup.Markup;
import ratpack.groovy.markup.internal.DefaultMarkup;
import ratpack.groovy.markuptemplates.MarkupTemplate;
import ratpack.groovy.templating.Template;
import ratpack.groovy.templating.internal.DefaultTemplate;
import ratpack.handling.Chain;
import ratpack.handling.Context;
import ratpack.handling.Handler;
import ratpack.handling.internal.ChainBuilders;
import ratpack.launch.LaunchConfig;
import ratpack.registry.Registry;
import ratpack.util.ExceptionUtils;

public abstract class Groovy {
    private Groovy() {
    }

    public static void ratpack(@DelegatesTo(value=Ratpack.class, strategy=1) Closure<?> closure) {
        try {
            RatpackScriptBacking.execute(closure);
        }
        catch (Exception e) {
            throw ExceptionUtils.uncheck((Throwable)e);
        }
    }

    public static Handler chain(LaunchConfig launchConfig, @DelegatesTo(value=GroovyChain.class, strategy=1) Closure<?> closure) throws Exception {
        return Groovy.chain(launchConfig, null, closure);
    }

    public static GroovyContext context(Context context) {
        return context instanceof GroovyContext ? (GroovyContext)context : new DefaultGroovyContext(context);
    }

    public static Handler chain(LaunchConfig launchConfig, Registry registry, @DelegatesTo(value=GroovyChain.class, strategy=1) Closure<?> closure) throws Exception {
        return ChainBuilders.build((launchConfig != null && launchConfig.isReloadable() ? 1 : 0) != 0, (Function)new GroovyDslChainActionTransformer(launchConfig, registry), new ClosureInvoker(closure).toAction(registry, 1));
    }

    public static Action<Chain> chainAction(final @DelegatesTo(value=GroovyChain.class, strategy=1) Closure<?> closure) throws Exception {
        return new Action<Chain>(){

            public void execute(Chain chain) throws Exception {
                ClosureUtil.configureDelegateFirst(new DefaultGroovyChain(chain), closure);
            }
        };
    }

    public static Template groovyTemplate(String id) {
        return Groovy.groovyTemplate(id, null);
    }

    public static MarkupTemplate groovyMarkupTemplate(String id) {
        return Groovy.groovyMarkupTemplate(id, null);
    }

    public static Template groovyTemplate(String id, String type) {
        return Groovy.groovyTemplate(ImmutableMap.of(), id, type);
    }

    public static MarkupTemplate groovyMarkupTemplate(String id, String type) {
        return Groovy.groovyMarkupTemplate(ImmutableMap.of(), id, type);
    }

    public static Template groovyTemplate(Map<String, ?> model, String id) {
        return Groovy.groovyTemplate(model, id, null);
    }

    public static MarkupTemplate groovyMarkupTemplate(Map<String, ?> model, String id) {
        return Groovy.groovyMarkupTemplate(model, id, null);
    }

    public static Template groovyTemplate(Map<String, ?> model, String id, String type) {
        return new DefaultTemplate(id, model, type);
    }

    public static MarkupTemplate groovyMarkupTemplate(Map<String, ?> model, String id, String type) {
        return new MarkupTemplate(id, type, model);
    }

    public static Handler groovyHandler(@DelegatesTo(value=GroovyContext.class, strategy=1) Closure<?> closure) {
        return new ClosureBackedHandler(closure);
    }

    public static void chain(Chain chain, @DelegatesTo(value=GroovyChain.class, strategy=1) Closure<?> closure) throws Exception {
        GroovyChain groovyChain = chain instanceof GroovyChain ? (GroovyChain)chain : new DefaultGroovyChain(chain);
        new ClosureInvoker(closure).invoke(chain.getRegistry(), groovyChain, 1);
    }

    public static Action<Chain> chain(final @DelegatesTo(value=GroovyChain.class, strategy=1) Closure<?> closure) throws Exception {
        return new GroovyChainAction(){

            @Override
            protected void execute() throws Exception {
                Groovy.chain(this.getChain(), closure);
            }
        };
    }

    public static Markup htmlBuilder(@DelegatesTo(value=MarkupBuilder.class, strategy=1) Closure<?> closure) {
        return Groovy.markupBuilder("text/html", "UTF-8", closure);
    }

    public static Markup markupBuilder(String contentType, String encoding, @DelegatesTo(value=MarkupBuilder.class, strategy=1) Closure<?> closure) {
        return new DefaultMarkup(contentType, encoding, closure);
    }

    public static interface Ratpack {
        public void bindings(@DelegatesTo(value=GroovyBindingsSpec.class, strategy=1) Closure<?> var1);

        public void handlers(@DelegatesTo(value=GroovyChain.class, strategy=1) Closure<?> var1);
    }
}

