/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.internal;

import groovy.lang.Closure;
import groovy.lang.Script;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.file.Path;
import ratpack.func.Action;
import ratpack.func.Factory;
import ratpack.func.Function;
import ratpack.groovy.internal.RatpackScriptBacking;
import ratpack.groovy.script.internal.ScriptEngine;
import ratpack.handling.Context;
import ratpack.handling.Handler;
import ratpack.reload.internal.ReloadableFileBackedFactory;
import ratpack.util.ExceptionUtils;
import ratpack.util.internal.IoUtils;

public class ScriptBackedApp
implements Handler {
    private final Factory<Handler> reloadHandler;
    private final Path script;

    public ScriptBackedApp(Path script, final boolean staticCompile, boolean reloadable, final Function<Closure<?>, Handler> closureTransformer) {
        this.script = script;
        this.reloadHandler = new ReloadableFileBackedFactory(script, reloadable, (ReloadableFileBackedFactory.Producer)new ReloadableFileBackedFactory.Producer<Handler>(){

            public Handler produce(final Path file, ByteBuf bytes) {
                try {
                    final String string = IoUtils.utf8String((ByteBuf)bytes);
                    final ScriptEngine<Script> scriptEngine = new ScriptEngine<Script>(this.getClass().getClassLoader(), staticCompile, Script.class);
                    Runnable runScript = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                scriptEngine.run(file.getFileName().toString(), string, new Object[0]);
                            }
                            catch (Exception e) {
                                throw ExceptionUtils.uncheck((Throwable)e);
                            }
                        }
                    };
                    ClosureCaptureAction backing = new ClosureCaptureAction();
                    RatpackScriptBacking.withBacking(backing, runScript);
                    return (Handler)closureTransformer.apply((Object)backing.closure);
                }
                catch (Exception e) {
                    throw ExceptionUtils.uncheck((Throwable)e);
                }
            }
        });
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ScriptBackedApp.this.reloadHandler.create();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).run();
    }

    public void handle(Context context) throws Exception {
        Handler handler;
        try {
            handler = (Handler)this.reloadHandler.create();
        }
        catch (Exception e) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)outputStream, "UTF-8"));
            e.printStackTrace(printWriter);
            printWriter.flush();
            context.getResponse().send("text/plain", outputStream.toByteArray());
            return;
        }
        if (handler == null) {
            context.getResponse().send("script file does not exist:" + this.script.toAbsolutePath());
        } else {
            handler.handle(context);
        }
    }

    private static class ClosureCaptureAction
    implements Action<Closure<?>> {
        private Closure<?> closure;

        private ClosureCaptureAction() {
        }

        public void execute(Closure<?> configurer) throws Exception {
            this.closure = configurer;
        }
    }
}

