/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.markuptemplates;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import groovy.text.markup.MarkupTemplateEngine;
import groovy.text.markup.TemplateConfiguration;
import groovy.text.markup.TemplateResolver;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Singleton;
import ratpack.groovy.markuptemplates.internal.MarkupTemplateRenderer;
import ratpack.launch.LaunchConfig;

public class MarkupTemplatingModule
extends AbstractModule {
    private String templatesDirectory = "templates";

    public String getTemplatesDirectory() {
        return this.templatesDirectory;
    }

    public void setTemplatesDirectory(String templatesDirectory) {
        this.templatesDirectory = templatesDirectory;
    }

    protected void configure() {
        this.bind(MarkupTemplateRenderer.class).in(Singleton.class);
    }

    @Provides
    @Singleton
    TemplateConfiguration provideTemplateConfiguration() {
        TemplateConfiguration templateConfiguration = new TemplateConfiguration();
        templateConfiguration.setAutoEscape(true);
        return templateConfiguration;
    }

    @Provides
    @Singleton
    MarkupTemplateEngine provideTemplateEngine(LaunchConfig launchConfig, TemplateConfiguration templateConfiguration) {
        if (launchConfig.isReloadable()) {
            templateConfiguration.setCacheTemplates(false);
        }
        ClassLoader parent = ((Object)((Object)this)).getClass().getClassLoader();
        try {
            parent = new URLClassLoader(new URL[]{launchConfig.getBaseDir().file(this.templatesDirectory).toFile().toURI().toURL()}, parent);
        }
        catch (MalformedURLException e) {
            parent = ((Object)((Object)this)).getClass().getClassLoader();
        }
        return new MarkupTemplateEngine(parent, templateConfiguration, (TemplateResolver)new CachingTemplateResolver());
    }

    private static class CachingTemplateResolver
    extends MarkupTemplateEngine.DefaultTemplateResolver {
        private final Map<String, URL> cachedResources = new ConcurrentHashMap<String, URL>();
        private boolean cache;

        private CachingTemplateResolver() {
        }

        public void configure(ClassLoader templateClassLoader, TemplateConfiguration configuration) {
            super.configure(templateClassLoader, configuration);
            this.cache = configuration.isCacheTemplates();
        }

        public URL resolveTemplate(String templatePath) throws IOException {
            URL url;
            if (this.cache && (url = this.cachedResources.get(templatePath)) != null) {
                return url;
            }
            url = super.resolveTemplate(templatePath);
            if (this.cache) {
                this.cachedResources.put(templatePath, url);
            }
            return url;
        }
    }
}

