/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.templating.internal;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import javax.inject.Inject;
import ratpack.exec.ExecControl;
import ratpack.exec.Promise;
import ratpack.file.FileSystemBinding;
import ratpack.func.Function;
import ratpack.groovy.script.internal.ScriptEngine;
import ratpack.groovy.templating.TemplatingConfig;
import ratpack.groovy.templating.internal.CompiledTemplate;
import ratpack.groovy.templating.internal.DefaultTemplateScript;
import ratpack.groovy.templating.internal.PathTemplateSource;
import ratpack.groovy.templating.internal.Render;
import ratpack.groovy.templating.internal.ResourceTemplateSource;
import ratpack.groovy.templating.internal.TemplateCompiler;
import ratpack.groovy.templating.internal.TemplateSource;
import ratpack.launch.LaunchConfig;

public class GroovyTemplateRenderingEngine {
    private static final String ERROR_TEMPLATE = "error.html";
    private final LoadingCache<TemplateSource, CompiledTemplate> compiledTemplateCache;
    private final TemplateCompiler templateCompiler;
    private final boolean reloadable;
    private final FileSystemBinding templateDir;
    private final ByteBufAllocator byteBufAllocator;
    private final ExecControl execControl;

    @Inject
    public GroovyTemplateRenderingEngine(LaunchConfig launchConfig, TemplatingConfig templatingConfig, ExecControl execControl) {
        this.execControl = execControl;
        this.byteBufAllocator = launchConfig.getBufferAllocator();
        ScriptEngine<DefaultTemplateScript> scriptEngine = new ScriptEngine<DefaultTemplateScript>(this.getClass().getClassLoader(), templatingConfig.isStaticallyCompile(), DefaultTemplateScript.class);
        this.templateCompiler = new TemplateCompiler(scriptEngine, this.byteBufAllocator);
        this.compiledTemplateCache = CacheBuilder.newBuilder().maximumSize((long)templatingConfig.getCacheSize()).build((CacheLoader)new CacheLoader<TemplateSource, CompiledTemplate>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public CompiledTemplate load(TemplateSource templateSource) throws Exception {
                ByteBuf content = templateSource.getContent();
                try {
                    CompiledTemplate compiledTemplate = GroovyTemplateRenderingEngine.this.templateCompiler.compile(content, templateSource.getName());
                    return compiledTemplate;
                }
                finally {
                    content.release();
                }
            }
        });
        this.reloadable = templatingConfig.isReloadable();
        String templatesPath = templatingConfig.getTemplatesPath();
        this.templateDir = launchConfig.getBaseDir().binding(templatesPath);
        if (this.templateDir == null) {
            throw new IllegalStateException("templatesPath '" + templatesPath + "' is outside the file system binding");
        }
    }

    public Promise<ByteBuf> renderTemplate(ByteBuf byteBuf, String templateId, Map<String, ?> model) throws Exception {
        Path templateFile = this.getTemplateFile(templateId);
        return this.render(byteBuf, this.toTemplateSource(templateId, templateFile), model);
    }

    private PathTemplateSource toTemplateSource(String templateId, Path templateFile) throws IOException {
        String id = templateId + (this.reloadable ? Files.getLastModifiedTime(templateFile, new LinkOption[0]) : "0");
        return new PathTemplateSource(id, templateFile, templateId);
    }

    public Promise<ByteBuf> renderError(ByteBuf byteBuf, Map<String, ?> model) throws Exception {
        Path errorTemplate = this.getTemplateFile(ERROR_TEMPLATE);
        if (Files.exists(errorTemplate, new LinkOption[0])) {
            return this.render(byteBuf, this.toTemplateSource(ERROR_TEMPLATE, errorTemplate), model);
        }
        return this.render(byteBuf, new ResourceTemplateSource(ERROR_TEMPLATE, this.byteBufAllocator), model);
    }

    private Promise<ByteBuf> render(ByteBuf byteBuf, TemplateSource templateSource, Map<String, ?> model) throws Exception {
        return Render.render(this.execControl, byteBuf, this.compiledTemplateCache, templateSource, model, new Function<String, TemplateSource>(){

            public TemplateSource apply(String templateName) throws IOException {
                return GroovyTemplateRenderingEngine.this.toTemplateSource(templateName, GroovyTemplateRenderingEngine.this.getTemplateFile(templateName));
            }
        });
    }

    private Path getTemplateFile(String templateName) {
        return this.templateDir.file(templateName);
    }
}

