/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.templating.internal;

import com.google.inject.Inject;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.HashMap;
import java.util.LinkedHashMap;
import ratpack.error.ClientErrorHandler;
import ratpack.func.Action;
import ratpack.groovy.templating.internal.GroovyTemplateRenderingEngine;
import ratpack.handling.Context;
import ratpack.util.ExceptionUtils;

public class TemplateRenderingClientErrorHandler
implements ClientErrorHandler {
    private final ByteBufAllocator byteBufAllocator;
    private final GroovyTemplateRenderingEngine renderer;

    @Inject
    public TemplateRenderingClientErrorHandler(ByteBufAllocator byteBufAllocator, GroovyTemplateRenderingEngine renderer) {
        this.byteBufAllocator = byteBufAllocator;
        this.renderer = renderer;
    }

    public void error(final Context context, int statusCode) throws Exception {
        HashMap<String, Object> model = new HashMap<String, Object>();
        HttpResponseStatus status = HttpResponseStatus.valueOf((int)statusCode);
        model.put("title", status.reasonPhrase());
        model.put("message", status.reasonPhrase());
        LinkedHashMap<String, String> metadata = new LinkedHashMap<String, String>();
        metadata.put("Request Method", context.getRequest().getMethod().getName());
        metadata.put("Request URL", context.getRequest().getUri());
        model.put("metadata", metadata);
        context.getResponse().status(statusCode).contentType("text/html");
        final ByteBuf byteBuf = this.byteBufAllocator.buffer();
        this.renderer.renderError(byteBuf, model).onError((Action)new Action<Throwable>(){

            public void execute(Throwable throwable) throws Exception {
                byteBuf.release();
                throw ExceptionUtils.toException((Throwable)throwable);
            }
        }).then((Action)new Action<ByteBuf>(){

            public void execute(ByteBuf byteBuf) throws Exception {
                context.getResponse().send(byteBuf);
            }
        });
    }
}

