/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.templating.internal;

import com.google.inject.Inject;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.util.Map;
import ratpack.error.ServerErrorHandler;
import ratpack.func.Action;
import ratpack.groovy.templating.internal.ExceptionToTemplateModel;
import ratpack.groovy.templating.internal.GroovyTemplateRenderingEngine;
import ratpack.handling.Context;
import ratpack.http.Response;
import ratpack.util.ExceptionUtils;

public class TemplateRenderingServerErrorHandler
implements ServerErrorHandler {
    private final ByteBufAllocator byteBufAllocator;
    private final GroovyTemplateRenderingEngine renderer;

    @Inject
    public TemplateRenderingServerErrorHandler(ByteBufAllocator byteBufAllocator, GroovyTemplateRenderingEngine renderer) {
        this.byteBufAllocator = byteBufAllocator;
        this.renderer = renderer;
    }

    public void error(final Context context, Exception exception) throws Exception {
        Map<String, ?> model = ExceptionToTemplateModel.transform(context.getRequest(), exception);
        Response response = context.getResponse();
        if (response.getStatus().getCode() < 400) {
            response.status(500);
        }
        final ByteBuf byteBuf = this.byteBufAllocator.buffer();
        this.renderer.renderError(byteBuf, model).onError((Action)new Action<Throwable>(){

            public void execute(Throwable thing) throws Exception {
                byteBuf.release();
                throw ExceptionUtils.toException((Throwable)thing);
            }
        }).then((Action)new Action<ByteBuf>(){

            public void execute(ByteBuf byteBuf) throws Exception {
                context.getResponse().send(byteBuf);
            }
        });
    }
}

