/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.internal;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import ratpack.func.Action;
import ratpack.groovy.script.internal.LineNumber;
import ratpack.groovy.script.internal.ScriptPath;

public abstract class ClosureUtil {
    private ClosureUtil() {
    }

    public static <D, R> R configureDelegateOnly(@DelegatesTo.Target D delegate, @DelegatesTo(strategy=3) Closure<R> configurer) {
        return ClosureUtil.configure(delegate, delegate, configurer, 3);
    }

    public static <D, R> R configureDelegateFirst(@DelegatesTo.Target D delegate, @DelegatesTo(strategy=1) Closure<R> configurer) {
        return ClosureUtil.configure(delegate, delegate, configurer, 1);
    }

    public static <D, A, R> R configureDelegateFirst(@DelegatesTo.Target D delegate, A argument, @DelegatesTo(strategy=1) Closure<R> configurer) {
        return ClosureUtil.configure(delegate, argument, configurer, 1);
    }

    private static <R, D, A> R configure(D delegate, A argument, Closure<R> configurer, int resolveStrategy) {
        if (configurer == null) {
            return null;
        }
        Closure clone = (Closure)configurer.clone();
        clone.setDelegate(delegate);
        clone.setResolveStrategy(resolveStrategy);
        if (clone.getMaximumNumberOfParameters() == 0) {
            return (R)clone.call();
        }
        return (R)clone.call(argument);
    }

    public static <T> Action<T> delegatingAction(Class<T> type, final Closure<?> configurer) {
        return new Action<T>(){

            public void execute(T object) throws Exception {
                ClosureUtil.configureDelegateFirst(object, configurer);
            }
        };
    }

    public static <T> Action<T> delegatingAction(Closure<?> configurer) {
        return ClosureUtil.delegatingAction(Object.class, configurer);
    }

    public static Action<Object> action(Closure<?> closure) {
        Closure copy = closure.rehydrate(null, closure.getOwner(), closure.getThisObject());
        return new NoDelegateClosureAction(copy);
    }

    public static <D, A> Runnable delegateFirstRunnable(D delegate, A argument, Closure<?> closure) {
        return new DelegatingClosureRunnable(delegate, argument, closure);
    }

    public static <T> Closure<T> returning(T thing) {
        return new PassThroughClosure<T>(thing);
    }

    public static Closure<Void> noop() {
        return ClosureUtil.returning(null);
    }

    public static Path findScript(Closure<?> closure) {
        URI uri;
        Class<?> clazz = closure.getClass();
        ProtectionDomain protectionDomain = clazz.getProtectionDomain();
        CodeSource codeSource = protectionDomain.getCodeSource();
        URL location = codeSource.getLocation();
        try {
            uri = location.toURI();
        }
        catch (URISyntaxException e) {
            return null;
        }
        Path path = uri.toString().equals("file:/groovy/script") ? ClosureUtil.findScriptByAnnotation(closure) : Paths.get(uri);
        if (path != null && Files.exists(path, new LinkOption[0])) {
            return path;
        }
        return null;
    }

    private static Path findScriptByAnnotation(Closure<?> closure) {
        URI uri;
        Class<?> rootClass = ClosureUtil.getRootClass(closure);
        ScriptPath annotation = rootClass.getAnnotation(ScriptPath.class);
        if (annotation == null) {
            return null;
        }
        String scriptPath = annotation.value();
        try {
            uri = new URI(scriptPath);
        }
        catch (URISyntaxException e) {
            return null;
        }
        return Paths.get(uri);
    }

    private static Class<?> getRootClass(Object object) {
        Class<?> rootClass = object.getClass();
        Class<?> enclosingClass = rootClass.getEnclosingClass();
        while (enclosingClass != null) {
            rootClass = enclosingClass;
            enclosingClass = rootClass.getEnclosingClass();
        }
        return rootClass;
    }

    public static SourceInfo getSourceInfo(Closure<?> closure) {
        Class<?> closureClass = closure.getClass();
        LineNumber lineNumber = closureClass.getAnnotation(LineNumber.class);
        if (lineNumber == null) {
            return null;
        }
        Class<?> rootClass = ClosureUtil.getRootClass(closure);
        ScriptPath scriptPath = rootClass.getAnnotation(ScriptPath.class);
        if (scriptPath == null) {
            return null;
        }
        return new SourceInfo(scriptPath.value(), lineNumber.value());
    }

    public static class SourceInfo {
        private final String uri;
        private final int lineNumber;

        public SourceInfo(String uri, int lineNumber) {
            this.uri = uri;
            this.lineNumber = lineNumber;
        }

        public String getUri() {
            return this.uri;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }
    }

    private static class PassThroughClosure<T>
    extends Closure<T> {
        static final long serialVersionUID = 0L;
        private final T thing;

        public PassThroughClosure(T thing) {
            super(null);
            this.thing = thing;
        }

        protected T doCall() {
            return this.thing;
        }
    }

    private static class DelegatingClosureRunnable<D, A>
    implements Runnable {
        private final D delegate;
        private final A argument;
        private final Closure<?> closure;

        private DelegatingClosureRunnable(D delegate, A argument, Closure<?> closure) {
            this.delegate = delegate;
            this.argument = argument;
            this.closure = closure;
        }

        @Override
        public void run() {
            ClosureUtil.configureDelegateFirst(this.delegate, this.argument, this.closure);
        }
    }

    private static class NoDelegateClosureAction
    implements Action<Object> {
        private final Closure<?> copy;

        public NoDelegateClosureAction(Closure<?> copy) {
            this.copy = copy;
        }

        public void execute(Object thing) throws Exception {
            this.copy.call(thing);
        }
    }
}

