/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.internal;

import groovy.lang.Closure;
import groovy.lang.GroovySystem;
import java.io.File;
import java.nio.file.Path;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import ratpack.file.internal.DefaultFileSystemBinding;
import ratpack.func.Action;
import ratpack.groovy.internal.ClosureUtil;
import ratpack.groovy.launch.GroovyScriptFileHandlerFactory;
import ratpack.groovy.launch.internal.GroovyClosureHandlerFactory;
import ratpack.groovy.launch.internal.GroovyVersionCheck;
import ratpack.launch.HandlerFactory;
import ratpack.launch.LaunchConfig;
import ratpack.launch.LaunchConfigs;
import ratpack.launch.internal.DelegatingLaunchConfig;
import ratpack.server.RatpackServer;
import ratpack.server.RatpackServerBuilder;

public class StandaloneScriptBacking
implements Action<Closure<?>> {
    private static final AtomicReference<Action<? super RatpackServer>> CAPTURE_ACTION = new AtomicReference<Object>(null);

    public static void captureNext(Action<? super RatpackServer> action) {
        CAPTURE_ACTION.set(action);
    }

    public void execute(Closure<?> closure) throws Exception {
        GroovyVersionCheck.ensureRequiredVersionUsed(GroovySystem.getVersion());
        Path scriptFile = ClosureUtil.findScript(closure);
        Properties defaultProperties = new Properties();
        Path baseDir = scriptFile == null ? new File(System.getProperty("user.dir")).toPath() : scriptFile.getParent();
        Properties properties = this.createProperties(scriptFile);
        Path configFile = new DefaultFileSystemBinding(baseDir).file("ratpack.properties");
        Object launchConfig = LaunchConfigs.createFromFile((ClassLoader)closure.getClass().getClassLoader(), (Path)baseDir, (Path)configFile, (Properties)properties, (Properties)defaultProperties);
        if (scriptFile == null) {
            launchConfig = new DelegatingLaunchConfig((LaunchConfig)launchConfig, (Closure)closure){
                final /* synthetic */ Closure val$closure;
                {
                    this.val$closure = closure;
                    super(x0);
                }

                public HandlerFactory getHandlerFactory() {
                    return new GroovyClosureHandlerFactory(this.val$closure);
                }
            };
        }
        RatpackServer server = RatpackServerBuilder.build((LaunchConfig)launchConfig);
        Action action = CAPTURE_ACTION.getAndSet(null);
        if (action != null) {
            action.execute((Object)server);
        }
        server.start();
        try {
            while (server.isRunning() && !Thread.interrupted()) {
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException ignore) {
            // empty catch block
        }
        server.stop();
    }

    protected Properties createProperties(Path scriptFile) {
        Properties properties = LaunchConfigs.getDefaultPrefixedProperties();
        properties.setProperty("handlerFactory", GroovyScriptFileHandlerFactory.class.getName());
        properties.setProperty("development", "true");
        if (scriptFile != null) {
            properties.setProperty("other.groovy.script", scriptFile.getFileName().toString());
        }
        return properties;
    }
}

