/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.markuptemplates;

import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import groovy.text.markup.MarkupTemplateEngine;
import groovy.text.markup.TemplateConfiguration;
import groovy.text.markup.TemplateResolver;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.concurrent.ExecutionException;
import javax.inject.Singleton;
import ratpack.groovy.markuptemplates.MarkupTemplate;
import ratpack.groovy.markuptemplates.internal.MarkupTemplateRenderer;
import ratpack.launch.LaunchConfig;
import ratpack.render.Renderer;
import ratpack.util.ExceptionUtils;

public class MarkupTemplatingModule
extends AbstractModule {
    private String templatesDirectory = "templates";

    public String getTemplatesDirectory() {
        return this.templatesDirectory;
    }

    public void setTemplatesDirectory(String templatesDirectory) {
        this.templatesDirectory = templatesDirectory;
    }

    protected void configure() {
        this.bind((TypeLiteral)new TypeLiteral<Renderer<MarkupTemplate>>(){}).to(MarkupTemplateRenderer.class).in(Singleton.class);
    }

    @Provides
    @Singleton
    TemplateConfiguration provideTemplateConfiguration() {
        TemplateConfiguration templateConfiguration = new TemplateConfiguration();
        templateConfiguration.setAutoEscape(true);
        return templateConfiguration;
    }

    @Provides
    @Singleton
    MarkupTemplateEngine provideTemplateEngine(LaunchConfig launchConfig, TemplateConfiguration templateConfiguration) {
        if (launchConfig.isDevelopment()) {
            templateConfiguration.setCacheTemplates(false);
        }
        ClassLoader parent = ((Object)((Object)this)).getClass().getClassLoader();
        return new MarkupTemplateEngine(parent, templateConfiguration, (TemplateResolver)new CachingTemplateResolver(launchConfig.getBaseDir().file(this.templatesDirectory)));
    }

    private static class CachingTemplateResolver
    extends MarkupTemplateEngine.DefaultTemplateResolver {
        private final LoadingCache<String, URL> urlCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, URL>(){

            public URL load(String key) throws Exception {
                return CachingTemplateResolver.this.doLoad(key);
            }
        });
        private final Path templatesDir;

        private URL doLoad(String key) throws MalformedURLException {
            return this.templatesDir.resolve(key).toUri().toURL();
        }

        public CachingTemplateResolver(Path templatesDir) {
            this.templatesDir = templatesDir;
        }

        public URL resolveTemplate(String templatePath) throws IOException {
            try {
                return (URL)this.urlCache.get((Object)templatePath);
            }
            catch (ExecutionException e) {
                Throwables.propagateIfInstanceOf((Throwable)e, IOException.class);
                throw ExceptionUtils.uncheck((Throwable)e);
            }
        }
    }
}

