/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.templating.internal;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.inject.Singleton;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import javax.inject.Inject;
import ratpack.exec.ExecControl;
import ratpack.exec.Promise;
import ratpack.file.FileSystemBinding;
import ratpack.func.Function;
import ratpack.groovy.script.internal.ScriptEngine;
import ratpack.groovy.templating.TemplatingConfig;
import ratpack.groovy.templating.internal.CompiledTemplate;
import ratpack.groovy.templating.internal.DefaultTemplateScript;
import ratpack.groovy.templating.internal.Render;
import ratpack.groovy.templating.internal.TemplateCompiler;
import ratpack.groovy.templating.internal.TemplateSource;
import ratpack.launch.LaunchConfig;

@Singleton
public class GroovyTemplateRenderingEngine {
    private final LoadingCache<TemplateSource, CompiledTemplate> compiledTemplateCache;
    private final TemplateCompiler templateCompiler;
    private final boolean reloadable;
    private final FileSystemBinding templateDir;
    private final ExecControl execControl;

    @Inject
    public GroovyTemplateRenderingEngine(LaunchConfig launchConfig, TemplatingConfig templatingConfig, ExecControl execControl) {
        this.execControl = execControl;
        ScriptEngine<DefaultTemplateScript> scriptEngine = new ScriptEngine<DefaultTemplateScript>(this.getClass().getClassLoader(), templatingConfig.isStaticallyCompile(), DefaultTemplateScript.class);
        this.templateCompiler = new TemplateCompiler(scriptEngine, launchConfig.getBufferAllocator());
        this.compiledTemplateCache = CacheBuilder.newBuilder().maximumSize((long)templatingConfig.getCacheSize()).build((CacheLoader)new CacheLoader<TemplateSource, CompiledTemplate>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public CompiledTemplate load(TemplateSource templateSource) throws Exception {
                ByteBuf content = templateSource.getContent();
                try {
                    CompiledTemplate compiledTemplate = GroovyTemplateRenderingEngine.this.templateCompiler.compile(content, templateSource.getName());
                    return compiledTemplate;
                }
                finally {
                    content.release();
                }
            }
        });
        this.reloadable = templatingConfig.isReloadable();
        String templatesPath = templatingConfig.getTemplatesPath();
        this.templateDir = launchConfig.getBaseDir().binding(templatesPath);
        if (this.templateDir == null) {
            throw new IllegalStateException("templatesPath '" + templatesPath + "' is outside the file system binding");
        }
    }

    public Promise<ByteBuf> renderTemplate(ByteBuf byteBuf, String templateId, Map<String, ?> model) throws Exception {
        Path templateFile = this.getTemplateFile(templateId);
        return this.render(byteBuf, this.toTemplateSource(templateId, templateFile), model);
    }

    private TemplateSource toTemplateSource(String templateId, Path templateFile) throws IOException {
        String id = templateId + (this.reloadable ? Files.getLastModifiedTime(templateFile, new LinkOption[0]) : "0");
        return new TemplateSource(id, templateFile, templateId);
    }

    private Promise<ByteBuf> render(ByteBuf byteBuf, TemplateSource templateSource, Map<String, ?> model) throws Exception {
        return Render.render(this.execControl, byteBuf, this.compiledTemplateCache, templateSource, model, (Function<String, TemplateSource>)((Function)templateName -> this.toTemplateSource((String)templateName, this.getTemplateFile((String)templateName))));
    }

    private Path getTemplateFile(String templateName) {
        return this.templateDir.file(templateName);
    }
}

