/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.internal;

import groovy.lang.Closure;
import groovy.lang.GroovySystem;
import java.nio.file.Path;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import ratpack.func.Action;
import ratpack.groovy.Groovy;
import ratpack.groovy.internal.ClosureUtil;
import ratpack.groovy.internal.GroovyVersionCheck;
import ratpack.guice.Guice;
import ratpack.server.RatpackServer;
import ratpack.server.RatpackServerSpec;
import ratpack.server.ServerConfig;
import ratpack.server.ServerConfigBuilder;
import ratpack.util.Exceptions;

public class StandaloneScriptBacking
implements Action<Closure<?>> {
    private final Lock lock = new ReentrantLock();
    private RatpackServer running;
    public static final StandaloneScriptBacking INSTANCE = new StandaloneScriptBacking();

    private StandaloneScriptBacking() {
    }

    public void execute(Closure<?> closure) throws Exception {
        GroovyVersionCheck.ensureRequiredVersionUsed(GroovySystem.getVersion());
        this.lock.lock();
        try {
            Path scriptFile;
            if (this.running != null) {
                this.running.stop();
                this.running = null;
            }
            this.running = (scriptFile = ClosureUtil.findScript(closure)) == null ? RatpackServer.start(server -> ClosureUtil.configureDelegateFirst(new RatpackBacking((RatpackServerSpec)server), closure)) : RatpackServer.start(Groovy.Script.app(scriptFile));
        }
        finally {
            this.lock.unlock();
        }
    }

    private static class RatpackBacking
    implements Groovy.Ratpack {
        private final RatpackServerSpec server;

        public RatpackBacking(RatpackServerSpec server) {
            this.server = server;
        }

        @Override
        public void bindings(Closure<?> configurer) {
            this.server.registry(Guice.registry(ClosureUtil.delegatingAction(configurer)));
        }

        @Override
        public void handlers(Closure<?> configurer) {
            Exceptions.uncheck(() -> this.server.handlers(Groovy.chainAction(configurer)));
        }

        @Override
        public void serverConfig(Closure<?> configurer) {
            ServerConfigBuilder builder = ServerConfig.builder().development(true);
            ClosureUtil.configureDelegateFirst(builder, configurer);
            this.server.serverConfig(builder);
        }
    }
}

