/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.internal.capture;

import groovy.lang.Binding;
import groovy.lang.Script;
import java.nio.file.Path;
import ratpack.func.BiFunction;
import ratpack.func.Function;
import ratpack.groovy.Groovy;
import ratpack.groovy.internal.capture.RatpackDslClosures;
import ratpack.groovy.script.internal.ScriptEngine;

public class RatpackDslScriptCapture
implements BiFunction<Path, String, RatpackDslClosures> {
    private final boolean compileStatic;
    private final String[] args;
    private final Function<? super RatpackDslClosures, ? extends Groovy.Ratpack> function;

    public RatpackDslScriptCapture(boolean compileStatic, String[] args, Function<? super RatpackDslClosures, ? extends Groovy.Ratpack> function) {
        this.compileStatic = compileStatic;
        this.args = args;
        this.function = function;
    }

    public RatpackDslClosures apply(Path file, String scriptContent) throws Exception {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ScriptEngine<Script> scriptEngine = new ScriptEngine<Script>(classLoader, this.compileStatic, Script.class);
        return RatpackDslClosures.capture(this.function, () -> {
            Object script = scriptEngine.create(file.getFileName().toString(), file, scriptContent, new Object[0]);
            script.setBinding(new Binding(this.args));
            script.run();
        });
    }
}

