/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.internal;

import groovy.lang.Closure;
import groovy.lang.GroovySystem;
import java.nio.file.Path;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import ratpack.func.Action;
import ratpack.groovy.Groovy;
import ratpack.groovy.internal.ClosureUtil;
import ratpack.groovy.internal.GroovyVersionCheck;
import ratpack.groovy.internal.capture.RatpackDslBacking;
import ratpack.groovy.internal.capture.RatpackDslClosures;
import ratpack.guice.Guice;
import ratpack.server.RatpackServer;
import ratpack.server.RatpackServerSpec;
import ratpack.server.ServerConfig;
import ratpack.server.ServerConfigBuilder;

public class StandaloneScriptBacking
implements Action<Closure<?>> {
    private final Lock lock = new ReentrantLock();
    private RatpackServer running;
    public static final StandaloneScriptBacking INSTANCE = new StandaloneScriptBacking();

    private StandaloneScriptBacking() {
    }

    public void execute(Closure<?> closure) throws Exception {
        GroovyVersionCheck.ensureRequiredVersionUsed(GroovySystem.getVersion());
        this.lock.lock();
        try {
            Path scriptFile;
            if (this.running != null) {
                this.running.stop();
                this.running = null;
            }
            this.running = (scriptFile = ClosureUtil.findScript(closure)) == null ? RatpackServer.start((Action)new ConsoleScriptConfigurer(closure)) : RatpackServer.start(Groovy.Script.app(scriptFile));
        }
        finally {
            this.lock.unlock();
        }
    }

    private static class ConsoleScriptConfigurer
    implements Action<RatpackServerSpec> {
        private final Closure<?> closure;

        public ConsoleScriptConfigurer(Closure<?> closure) {
            this.closure = closure;
        }

        public void execute(RatpackServerSpec server) throws Exception {
            RatpackDslClosures closures = new RatpackDslClosures(null);
            RatpackDslBacking backing = new RatpackDslBacking(closures);
            ClosureUtil.configureDelegateFirst(backing, this.closure);
            server.registry(Guice.registry(ClosureUtil.delegatingAction(closures.getBindings())));
            server.handlers(Groovy.chainAction(closures.getHandlers()));
            ServerConfigBuilder builder = ServerConfig.builder().development(true);
            ClosureUtil.configureDelegateFirst(builder, closures.getServerConfig());
            server.serverConfig(builder);
        }
    }
}

