/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.template.internal;

import groovy.lang.Writable;
import groovy.text.Template;
import groovy.text.markup.MarkupTemplateEngine;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import ratpack.file.MimeTypes;
import ratpack.groovy.template.MarkupTemplate;
import ratpack.handling.Context;
import ratpack.render.RendererSupport;

public class MarkupTemplateRenderer
extends RendererSupport<MarkupTemplate> {
    private final MarkupTemplateEngine engine;
    private final ByteBufAllocator byteBufAllocator;

    @Inject
    public MarkupTemplateRenderer(MarkupTemplateEngine engine, ByteBufAllocator byteBufAllocator) {
        this.engine = engine;
        this.byteBufAllocator = byteBufAllocator;
    }

    public void render(Context context, MarkupTemplate template) throws Exception {
        String contentType = template.getContentType();
        contentType = contentType == null ? ((MimeTypes)context.get(MimeTypes.class)).getContentType(template.getName()) : contentType;
        try {
            Template compiledTemplate = this.engine.createTemplateByPath(template.getName());
            Writable boundTemplate = compiledTemplate.make(template.getModel());
            ByteBuf byteBuf = this.byteBufAllocator.directBuffer();
            try {
                ByteBufOutputStream outputStream = new ByteBufOutputStream(byteBuf);
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outputStream, CharsetUtil.encoder((Charset)StandardCharsets.UTF_8));
                boundTemplate.writeTo((Writer)writer);
            }
            catch (Exception e) {
                byteBuf.release();
                throw e;
            }
            context.getResponse().send((CharSequence)contentType, byteBuf);
        }
        catch (IOException e) {
            context.error((Throwable)e);
        }
    }
}

