/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.script.internal;

import groovy.lang.GroovyClassLoader;
import groovy.lang.Script;
import groovy.transform.CompileStatic;
import groovy.transform.InheritConstructors;
import java.nio.file.Path;
import java.security.CodeSource;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.classgen.Verifier;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import ratpack.groovy.script.internal.LineNumber;
import ratpack.groovy.script.internal.ScriptPath;

public class ScriptEngine<T extends Script> {
    private static final ClassNode LINE_NUMBER_CLASS_NODE = new ClassNode(LineNumber.class);
    private final boolean staticCompile;
    private final Class<T> scriptBaseClass;
    private ClassLoader parentLoader;

    public ScriptEngine(ClassLoader parentLoader, boolean staticCompile, Class<T> scriptBaseClass) {
        this.parentLoader = parentLoader;
        this.staticCompile = staticCompile;
        this.scriptBaseClass = scriptBaseClass;
    }

    public T create(String scriptName, Path scriptPath, String scriptText, Object ... scriptConstructionArgs) throws IllegalAccessException, InstantiationException {
        Class<T> scriptClass = this.compile(scriptName, scriptPath, scriptText);
        return (T)((Script)DefaultGroovyMethods.newInstance(scriptClass, (Object[])scriptConstructionArgs));
    }

    public Class<T> compile(String scriptName, String scriptText) throws IllegalAccessException, InstantiationException {
        return this.createClassLoader(null).parseClass(scriptText, scriptName);
    }

    public Class<T> compile(String scriptName, Path scriptPath, String scriptText) throws IllegalAccessException, InstantiationException {
        return this.createClassLoader(scriptPath).parseClass(scriptText, scriptName);
    }

    private GroovyClassLoader createClassLoader(final Path scriptPath) {
        CompilerConfiguration compilerConfiguration = new CompilerConfiguration();
        if (!this.scriptBaseClass.equals(Script.class)) {
            compilerConfiguration.setScriptBaseClass(this.scriptBaseClass.getName());
        }
        compilerConfiguration.addCompilationCustomizers(new CompilationCustomizer[]{new CompilationCustomizer(CompilePhase.CONVERSION){

            public void call(SourceUnit source, GeneratorContext context, ClassNode classNode) throws CompilationFailedException {
                if (ScriptEngine.this.staticCompile) {
                    classNode.addAnnotation(new AnnotationNode(new ClassNode(CompileStatic.class)));
                }
                classNode.addAnnotation(new AnnotationNode(new ClassNode(InheritConstructors.class)));
                if (scriptPath != null) {
                    AnnotationNode scriptPathAnnotation = new AnnotationNode(new ClassNode(ScriptPath.class));
                    scriptPathAnnotation.addMember("value", (Expression)new ConstantExpression((Object)scriptPath.toUri().toString()));
                    classNode.addAnnotation(scriptPathAnnotation);
                }
            }
        }});
        return new GroovyClassLoader(this.parentLoader, compilerConfiguration){

            protected CompilationUnit createCompilationUnit(CompilerConfiguration config, CodeSource source) {
                return new CompilationUnit(config, source, this){
                    {
                        this.verifier = new Verifier(){

                            public void visitClass(ClassNode node) {
                                if (node.implementsInterface(ClassHelper.GENERATED_CLOSURE_Type)) {
                                    AnnotationNode lineNumberAnnotation = new AnnotationNode(LINE_NUMBER_CLASS_NODE);
                                    lineNumberAnnotation.addMember("value", (Expression)new ConstantExpression((Object)node.getLineNumber(), true));
                                    node.addAnnotation(lineNumberAnnotation);
                                }
                                super.visitClass(node);
                            }
                        };
                    }
                };
            }
        };
    }
}

