/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy;

import com.google.common.collect.ImmutableMap;
import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovy.lang.GroovySystem;
import groovy.xml.MarkupBuilder;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import ratpack.api.Nullable;
import ratpack.file.FileSystemBinding;
import ratpack.func.Action;
import ratpack.func.BiFunction;
import ratpack.func.Function;
import ratpack.groovy.handling.DefaultGroovyByContentSpec;
import ratpack.groovy.handling.GroovyByContentSpec;
import ratpack.groovy.handling.GroovyByMethodSpec;
import ratpack.groovy.handling.GroovyChain;
import ratpack.groovy.handling.GroovyContext;
import ratpack.groovy.handling.internal.ClosureBackedHandler;
import ratpack.groovy.handling.internal.DefaultGroovyByMethodSpec;
import ratpack.groovy.handling.internal.GroovyDslChainActionTransformer;
import ratpack.groovy.internal.ClosureInvoker;
import ratpack.groovy.internal.ClosureUtil;
import ratpack.groovy.internal.GroovyVersionCheck;
import ratpack.groovy.internal.ScriptBackedHandler;
import ratpack.groovy.internal.capture.BindingsOnly;
import ratpack.groovy.internal.capture.HandlersOnly;
import ratpack.groovy.internal.capture.RatpackDslBacking;
import ratpack.groovy.internal.capture.RatpackDslClosures;
import ratpack.groovy.internal.capture.RatpackDslScriptCapture;
import ratpack.groovy.internal.capture.RatpackScriptBacking;
import ratpack.groovy.script.ScriptNotFoundException;
import ratpack.groovy.template.Markup;
import ratpack.groovy.template.MarkupTemplate;
import ratpack.groovy.template.TextTemplate;
import ratpack.guice.BindingsSpec;
import ratpack.guice.Guice;
import ratpack.handling.ByContentSpec;
import ratpack.handling.ByMethodSpec;
import ratpack.handling.Chain;
import ratpack.handling.Handler;
import ratpack.handling.Handlers;
import ratpack.handling.internal.ChainBuilders;
import ratpack.http.internal.HttpHeaderConstants;
import ratpack.registry.Registry;
import ratpack.server.RatpackServerSpec;
import ratpack.server.ServerConfig;
import ratpack.server.ServerConfigBuilder;
import ratpack.server.internal.BaseDirFinder;
import ratpack.server.internal.FileBackedReloadInformant;
import ratpack.util.Exceptions;
import ratpack.util.internal.Paths2;

public abstract class Groovy {
    private Groovy() {
    }

    public static void ratpack(@DelegatesTo(value=Ratpack.class, strategy=1) Closure<?> closure) {
        try {
            RatpackScriptBacking.execute(closure);
        }
        catch (Exception e) {
            throw Exceptions.uncheck((Throwable)e);
        }
    }

    public static Handler chain(ServerConfig serverConfig, @DelegatesTo(value=GroovyChain.class, strategy=1) Closure<?> closure) throws Exception {
        return Groovy.chain(serverConfig, null, closure);
    }

    public static Handler chain(@Nullable ServerConfig serverConfig, @Nullable Registry registry, @DelegatesTo(value=GroovyChain.class, strategy=1) Closure<?> closure) throws Exception {
        return ChainBuilders.build((Function)new GroovyDslChainActionTransformer(serverConfig, registry), new ClosureInvoker(closure).toAction(registry, 1));
    }

    public static Handler chain(Registry registry, @DelegatesTo(value=GroovyChain.class, strategy=1) Closure<?> closure) throws Exception {
        return Groovy.chain((ServerConfig)registry.get(ServerConfig.class), registry, closure);
    }

    public static Action<Chain> chainAction(@DelegatesTo(value=GroovyChain.class, strategy=1) Closure<?> closure) {
        return chain -> ClosureUtil.configureDelegateFirst(GroovyChain.from(chain), closure);
    }

    public static TextTemplate groovyTemplate(String id) {
        return Groovy.groovyTemplate(id, null);
    }

    public static MarkupTemplate groovyMarkupTemplate(String id) {
        return Groovy.groovyMarkupTemplate(id, (String)null);
    }

    public static TextTemplate groovyTemplate(String id, String type) {
        return Groovy.groovyTemplate(ImmutableMap.of(), id, type);
    }

    public static MarkupTemplate groovyMarkupTemplate(String id, String type) {
        return Groovy.groovyMarkupTemplate(ImmutableMap.of(), id, type);
    }

    public static TextTemplate groovyTemplate(Map<String, ?> model, String id) {
        return Groovy.groovyTemplate(model, id, null);
    }

    public static MarkupTemplate groovyMarkupTemplate(Map<String, ?> model, String id) {
        return Groovy.groovyMarkupTemplate(model, id, null);
    }

    public static MarkupTemplate groovyMarkupTemplate(String id, Action<? super ImmutableMap.Builder<String, Object>> modelBuilder) {
        return Groovy.groovyMarkupTemplate(id, null, modelBuilder);
    }

    public static MarkupTemplate groovyMarkupTemplate(String id, String type, Action<? super ImmutableMap.Builder<String, Object>> modelBuilder) {
        ImmutableMap model = (ImmutableMap)Exceptions.uncheck(() -> ((ImmutableMap.Builder)Action.with((Object)ImmutableMap.builder(), (Action)Action.noopIfNull((Action)modelBuilder))).build());
        return Groovy.groovyMarkupTemplate(model, id, type);
    }

    public static TextTemplate groovyTemplate(Map<String, ?> model, String id, String type) {
        return new TextTemplate(model, id, type);
    }

    public static MarkupTemplate groovyMarkupTemplate(Map<String, ?> model, String id, String type) {
        return new MarkupTemplate(id, type, model);
    }

    public static Handler groovyHandler(@DelegatesTo(value=GroovyContext.class, strategy=1) Closure<?> closure) {
        return new ClosureBackedHandler(closure);
    }

    public static void chain(Chain chain, @DelegatesTo(value=GroovyChain.class, strategy=1) Closure<?> closure) throws Exception {
        new ClosureInvoker(closure).invoke(chain.getRegistry(), GroovyChain.from(chain), 1);
    }

    public static Action<Chain> chain(@DelegatesTo(value=GroovyChain.class, strategy=1) Closure<?> closure) throws Exception {
        return c -> Groovy.chain(c, closure);
    }

    public static Markup htmlBuilder(@DelegatesTo(value=MarkupBuilder.class, strategy=1) Closure<?> closure) {
        return Groovy.markupBuilder(HttpHeaderConstants.HTML_UTF_8, CharsetUtil.UTF_8, closure);
    }

    public static Markup markupBuilder(CharSequence contentType, CharSequence encoding, @DelegatesTo(value=MarkupBuilder.class, strategy=1) Closure<?> closure) {
        return new Markup(contentType, Charset.forName(encoding.toString()), closure);
    }

    public static Markup markupBuilder(CharSequence contentType, Charset encoding, @DelegatesTo(value=MarkupBuilder.class, strategy=1) Closure<?> closure) {
        return new Markup(contentType, encoding, closure);
    }

    public static Handler byContent(Registry registry, @DelegatesTo(value=GroovyByMethodSpec.class, strategy=1) Closure<?> closure) throws Exception {
        return Handlers.byContent((Registry)registry, s -> ClosureUtil.configureDelegateFirst(new DefaultGroovyByContentSpec((ByContentSpec)s), closure));
    }

    public static Handler byMethod(Registry registry, @DelegatesTo(value=GroovyByContentSpec.class, strategy=1) Closure<?> closure) throws Exception {
        return Handlers.byMethod((Registry)registry, s -> ClosureUtil.configureDelegateFirst(new DefaultGroovyByMethodSpec((ByMethodSpec)s), closure));
    }

    public static abstract class Script {
        public static final String DEFAULT_HANDLERS_PATH = "handlers.groovy";
        public static final String DEFAULT_BINDINGS_PATH = "bindings.groovy";
        public static final String DEFAULT_APP_PATH = "ratpack.groovy";

        private Script() {
        }

        public static void checkGroovy() {
            GroovyVersionCheck.ensureRequiredVersionUsed(GroovySystem.getVersion());
        }

        public static Action<? super RatpackServerSpec> app() {
            return Script.app(false);
        }

        public static Action<? super RatpackServerSpec> app(boolean compileStatic) {
            return Script.app(compileStatic, DEFAULT_APP_PATH, DEFAULT_APP_PATH.substring(0, 1).toUpperCase() + DEFAULT_APP_PATH.substring(1));
        }

        public static Action<? super RatpackServerSpec> app(Path script) {
            return Script.app(false, script);
        }

        public static Action<? super RatpackServerSpec> app(boolean compileStatic, Path script) {
            return b -> Script.doApp(b, compileStatic, script.getParent(), script, new String[0]);
        }

        public static Action<? super RatpackServerSpec> app(boolean compileStatic, String ... scriptPaths) {
            return Script.appWithArgs(compileStatic, scriptPaths, new String[0]);
        }

        public static Action<? super RatpackServerSpec> appWithArgs(String ... args) {
            return Script.appWithArgs(false, new String[]{DEFAULT_APP_PATH, DEFAULT_APP_PATH.substring(0, 1).toUpperCase() + DEFAULT_APP_PATH.substring(1)}, args);
        }

        public static Action<? super RatpackServerSpec> appWithArgs(boolean compileStatic, Path script, String ... args) {
            return b -> Script.doApp(b, compileStatic, script.getParent(), script, args);
        }

        public static Action<? super RatpackServerSpec> appWithArgs(boolean compileStatic, String[] scriptPaths, String ... args) {
            return b -> {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                BaseDirFinder.Result baseDirResult = Arrays.stream(scriptPaths).map(scriptPath -> BaseDirFinder.find((ClassLoader)classLoader, (String)scriptPath)).filter(Optional::isPresent).map(Optional::get).findFirst().orElseThrow(() -> new ScriptNotFoundException(scriptPaths));
                Path baseDir = baseDirResult.getBaseDir();
                Path scriptFile = baseDirResult.getResource();
                Script.doApp(b, compileStatic, baseDir, scriptFile, args);
            };
        }

        private static void doApp(RatpackServerSpec definition, boolean compileStatic, Path baseDir, Path scriptFile, String ... args) throws Exception {
            String script = Paths2.readText((Path)scriptFile, (Charset)StandardCharsets.UTF_8);
            RatpackDslClosures closures = new RatpackDslScriptCapture(compileStatic, args, (Function<? super RatpackDslClosures, ? extends Ratpack>)((Function)RatpackDslBacking::new)).apply(scriptFile, script);
            definition.serverConfig(ClosureUtil.configureDelegateFirstAndReturn(Script.loadPropsIfPresent(ServerConfig.builder().baseDir(baseDir), baseDir), closures.getServerConfig()));
            definition.registry(r -> (Registry)Guice.registry(bindingsSpec -> {
                bindingsSpec.bindInstance((Object)new FileBackedReloadInformant(scriptFile));
                ClosureUtil.configureDelegateFirst(bindingsSpec, closures.getBindings());
            }).apply(r));
            definition.handler(r -> Groovy.chain(r, closures.getHandlers()));
        }

        private static ServerConfigBuilder loadPropsIfPresent(ServerConfigBuilder serverConfigBuilder, Path baseDir) {
            Path propsFile = baseDir.resolve(".ratpack");
            if (Files.exists(propsFile, new LinkOption[0])) {
                serverConfigBuilder.props(propsFile);
            }
            return serverConfigBuilder;
        }

        public static Function<Registry, Handler> handlers() {
            return Script.handlers(false);
        }

        public static Function<Registry, Handler> handlers(boolean compileStatic) {
            return Script.handlers(compileStatic, DEFAULT_HANDLERS_PATH);
        }

        public static Function<Registry, Handler> handlers(boolean compileStatic, String scriptPath) {
            return Script.handlersWithArgs(compileStatic, scriptPath, new String[0]);
        }

        public static Function<Registry, Handler> handlersWithArgs(boolean compileStatic, String scriptPath, String ... args) {
            Script.checkGroovy();
            return r -> {
                Path scriptFile = ((FileSystemBinding)r.get(FileSystemBinding.class)).file(scriptPath);
                boolean development = ((ServerConfig)r.get(ServerConfig.class)).isDevelopment();
                return new ScriptBackedHandler(scriptFile, development, (BiFunction<? super Path, ? super String, ? extends Handler>)new RatpackDslScriptCapture(compileStatic, args, (Function<? super RatpackDslClosures, ? extends Ratpack>)((Function)HandlersOnly::new)).andThen(RatpackDslClosures::getHandlers).andThen(c -> Groovy.chain(r, c)));
            };
        }

        public static Function<Registry, Registry> bindings() {
            return Script.bindings(false);
        }

        public static Function<Registry, Registry> bindings(boolean compileStatic) {
            return Script.bindings(compileStatic, DEFAULT_BINDINGS_PATH);
        }

        public static Function<Registry, Registry> bindings(boolean compileStatic, String scriptPath) {
            return Script.bindingsWithArgs(compileStatic, scriptPath, new String[0]);
        }

        public static Function<Registry, Registry> bindingsWithArgs(boolean compileStatic, String scriptPath, String ... args) {
            Script.checkGroovy();
            return r -> {
                Path scriptFile = ((FileSystemBinding)r.get(FileSystemBinding.class)).file(scriptPath);
                String script = Paths2.readText((Path)scriptFile, (Charset)StandardCharsets.UTF_8);
                Closure bindingsClosure = (Closure)new RatpackDslScriptCapture(compileStatic, args, (Function<? super RatpackDslClosures, ? extends Ratpack>)((Function)BindingsOnly::new)).andThen(RatpackDslClosures::getBindings).apply((Object)scriptFile, (Object)script);
                return (Registry)Guice.registry(bindingsSpec -> {
                    bindingsSpec.bindInstance((Object)new FileBackedReloadInformant(scriptFile));
                    ClosureUtil.configureDelegateFirst(bindingsSpec, bindingsClosure);
                }).apply(r);
            };
        }
    }

    public static interface Ratpack {
        public void bindings(@DelegatesTo(value=BindingsSpec.class, strategy=1) Closure<?> var1);

        public void handlers(@DelegatesTo(value=GroovyChain.class, strategy=1) Closure<?> var1);

        public void serverConfig(@DelegatesTo(value=ServerConfigBuilder.class, strategy=1) Closure<?> var1);

        public void include(Path var1);

        public void include(String var1);
    }
}

