/*
 * Decompiled with CFR 0.152.
 */
package ratpack.session.clientside;

import com.google.inject.Injector;
import com.google.inject.Provides;
import io.netty.util.CharsetUtil;
import javax.crypto.spec.SecretKeySpec;
import javax.inject.Singleton;
import ratpack.guice.ConfigurableModule;
import ratpack.guice.HandlerDecoratingModule;
import ratpack.handling.Handler;
import ratpack.session.clientside.Crypto;
import ratpack.session.clientside.SessionService;
import ratpack.session.clientside.Signer;
import ratpack.session.clientside.internal.CookieBasedSessionStorageBindingHandler;
import ratpack.session.clientside.internal.DefaultClientSessionService;
import ratpack.session.clientside.internal.DefaultCrypto;
import ratpack.session.clientside.internal.DefaultSigner;

public class ClientSideSessionsModule
extends ConfigurableModule<Config>
implements HandlerDecoratingModule {
    protected void configure() {
    }

    @Provides
    @Singleton
    Signer provideSigner(Config config) {
        byte[] token = config.getSecretToken().getBytes(CharsetUtil.UTF_8);
        return new DefaultSigner(new SecretKeySpec(token, config.getMacAlgorithm()));
    }

    @Provides
    @Singleton
    Crypto provideCrypto(Config config) {
        DefaultCrypto crypto = null;
        if (config.getSecretKey() != null && config.getCipherAlgorithm() != null) {
            byte[] key = config.getSecretKey().getBytes(CharsetUtil.UTF_8);
            crypto = new DefaultCrypto(key, config.getCipherAlgorithm());
        }
        return crypto;
    }

    @Provides
    @Singleton
    SessionService provideSessionService(Config config, Signer signer, Crypto crypto) {
        SessionService sessionService = config.getSessionService();
        if (sessionService == null) {
            sessionService = new DefaultClientSessionService(signer, crypto);
        }
        return sessionService;
    }

    public Handler decorate(Injector injector, Handler handler) {
        return new CookieBasedSessionStorageBindingHandler((SessionService)injector.getInstance(SessionService.class), ((Config)injector.getInstance(Config.class)).getSessionName(), handler);
    }

    public static class Config {
        private String sessionName = "ratpack_session";
        private String secretToken = Long.toString(System.currentTimeMillis() / 10000L);
        private String macAlgorithm = "HmacSHA1";
        private String secretKey;
        private String cipherAlgorithm = "AES/CBC/PKCS5Padding";
        private SessionService sessionService;

        public String getSessionName() {
            return this.sessionName;
        }

        public void setSessionName(String sessionName) {
            this.sessionName = sessionName;
        }

        public String getSecretToken() {
            return this.secretToken;
        }

        public void setSecretToken(String secretToken) {
            this.secretToken = secretToken;
        }

        public String getMacAlgorithm() {
            return this.macAlgorithm;
        }

        public void setMacAlgorithm(String macAlgorithm) {
            this.macAlgorithm = macAlgorithm;
        }

        public String getSecretKey() {
            return this.secretKey;
        }

        public void setSecretKey(String secretKey) {
            this.secretKey = secretKey;
        }

        public String getCipherAlgorithm() {
            return this.cipherAlgorithm;
        }

        public void setCipherAlgorithm(String cipherAlgorithm) {
            this.cipherAlgorithm = cipherAlgorithm;
        }

        public SessionService getSessionService() {
            return this.sessionService;
        }

        public void setSessionService(SessionService sessionService) {
            this.sessionService = sessionService;
        }
    }
}

