/*
 * Decompiled with CFR 0.152.
 */
package ratpack.session.clientside.internal;

import com.google.common.collect.Iterables;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.http.Cookie;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import ratpack.handling.Context;
import ratpack.handling.Handler;
import ratpack.http.ResponseMetaData;
import ratpack.session.clientside.SessionService;
import ratpack.session.clientside.internal.InitialStorageContainer;
import ratpack.session.store.SessionStorage;
import ratpack.session.store.internal.DefaultSessionStorage;

public class CookieBasedSessionStorageBindingHandler
implements Handler {
    private final SessionService sessionService;
    private final String sessionName;
    private final Handler handler;

    public CookieBasedSessionStorageBindingHandler(SessionService sessionService, String sessionName, Handler handler) {
        this.sessionService = sessionService;
        this.sessionName = sessionName;
        this.handler = handler;
    }

    public void handle(Context context) {
        context.getRequest().addLazy(SessionStorage.class, () -> {
            Cookie sessionCookie = (Cookie)Iterables.find((Iterable)context.getRequest().getCookies(), c -> this.sessionName.equals(c.name()), null);
            ConcurrentMap<String, Object> sessionMap = this.sessionService.deserializeSession(sessionCookie);
            DefaultSessionStorage storage = new DefaultSessionStorage(sessionMap);
            ConcurrentHashMap<String, Object> initialSessionMap = new ConcurrentHashMap<String, Object>(sessionMap);
            context.getRequest().add(InitialStorageContainer.class, (Object)new InitialStorageContainer(new DefaultSessionStorage(initialSessionMap)));
            return storage;
        });
        context.getResponse().beforeSend(responseMetaData -> {
            Optional storageOptional = context.getRequest().maybeGet(SessionStorage.class);
            if (storageOptional.isPresent()) {
                boolean hasChanged;
                SessionStorage storage = (SessionStorage)storageOptional.get();
                boolean bl = hasChanged = !((InitialStorageContainer)context.getRequest().get(InitialStorageContainer.class)).isSameAsInitial(storage);
                if (hasChanged) {
                    Set<Map.Entry<String, Object>> entries = storage.entrySet();
                    if (entries.isEmpty()) {
                        this.invalidateSession((ResponseMetaData)responseMetaData);
                    } else {
                        ByteBufAllocator bufferAllocator = (ByteBufAllocator)context.get(ByteBufAllocator.class);
                        String cookieValue = this.sessionService.serializeSession(bufferAllocator, entries);
                        responseMetaData.cookie(this.sessionName, cookieValue);
                    }
                }
            }
        });
        context.insert(new Handler[]{this.handler});
    }

    private void invalidateSession(ResponseMetaData responseMetaData) {
        responseMetaData.expireCookie(this.sessionName);
    }
}

