/*
 * Decompiled with CFR 0.152.
 */
package ratpack.session.clientside.internal;

import io.netty.buffer.ByteBuf;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import ratpack.session.clientside.Signer;
import ratpack.util.ExceptionUtils;

public class DefaultSigner
implements Signer {
    private final SecretKeySpec secretKeySpec;

    public DefaultSigner(SecretKeySpec secretKeySpec) {
        this.secretKeySpec = secretKeySpec;
    }

    @Override
    public byte[] sign(ByteBuf message) {
        return (byte[])ExceptionUtils.uncheck(() -> {
            Mac mac = Mac.getInstance(this.secretKeySpec.getAlgorithm());
            mac.init(this.secretKeySpec);
            mac.update(message.nioBuffer());
            return mac.doFinal();
        });
    }
}

