/*
 * Decompiled with CFR 0.152.
 */
package ratpack.session.clientside.internal;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import ratpack.session.clientside.Crypto;
import ratpack.util.Exceptions;

public class DefaultCrypto
implements Crypto {
    private final SecretKeySpec secretKeySpec;
    private final String algorithm;
    private final boolean isInitializationVectorRequired;

    public DefaultCrypto(byte[] key, String algorithm) {
        String[] parts = algorithm.split("/");
        this.secretKeySpec = new SecretKeySpec(key, parts[0]);
        this.algorithm = algorithm;
        this.isInitializationVectorRequired = parts.length > 1 && !parts[1].equalsIgnoreCase("ECB");
    }

    @Override
    public byte[] encrypt(ByteBuf message) {
        return (byte[])Exceptions.uncheck(() -> {
            Cipher cipher = Cipher.getInstance(this.algorithm);
            cipher.init(1, this.secretKeySpec);
            int blockSize = cipher.getBlockSize();
            int messageLength = message.readableBytes();
            int encMessageLength = cipher.getOutputSize(messageLength);
            ByteBuf paddedMessage = null;
            if (messageLength == encMessageLength && encMessageLength % blockSize != 0) {
                int paddedMessageSize = messageLength + blockSize - messageLength % blockSize;
                paddedMessage = Unpooled.wrappedBuffer((byte[])new byte[paddedMessageSize]);
                paddedMessage.setZero(0, paddedMessageSize);
                paddedMessage.setBytes(0, message, messageLength);
                encMessageLength = cipher.getOutputSize(paddedMessageSize);
            }
            ByteBuf encMessage = Unpooled.wrappedBuffer((byte[])new byte[encMessageLength]);
            cipher.doFinal(paddedMessage != null ? paddedMessage.nioBuffer() : message.nioBuffer(), encMessage.nioBuffer());
            byte[] payload = encMessage.array();
            if (paddedMessage != null) {
                paddedMessage.release();
            }
            encMessage.release();
            if (this.isInitializationVectorRequired) {
                byte[] ivBytes = cipher.getIV();
                int outputLength = 1 + ivBytes.length + payload.length;
                ByteBuf output = Unpooled.wrappedBuffer((byte[])new byte[outputLength]).resetWriterIndex().writeByte(ivBytes.length).writeBytes(ivBytes).writeBytes(payload);
                payload = output.array();
                output.release();
            }
            return payload;
        });
    }

    @Override
    public byte[] decrypt(ByteBuf message) {
        return (byte[])Exceptions.uncheck(() -> {
            Cipher cipher = Cipher.getInstance(this.algorithm);
            if (this.isInitializationVectorRequired) {
                byte ivByteLength = message.readByte();
                ByteBuf ivBytes = message.readBytes((int)ivByteLength);
                IvParameterSpec ivParameterSpec = new IvParameterSpec(ivBytes.array());
                ivBytes.release();
                cipher.init(2, (Key)this.secretKeySpec, ivParameterSpec);
            } else {
                cipher.init(2, this.secretKeySpec);
            }
            int messageLength = message.readableBytes();
            ByteBuf decMessage = Unpooled.wrappedBuffer((byte[])new byte[cipher.getOutputSize(messageLength)]);
            ByteBuffer nioDecMessageBuf = decMessage.nioBuffer();
            int count = cipher.doFinal(message.readBytes(messageLength).nioBuffer(), nioDecMessageBuf);
            for (int i = count - 1; i >= 0 && nioDecMessageBuf.get(i) == 0; --i) {
                --count;
            }
            byte[] decrypted = new byte[count];
            nioDecMessageBuf.position(0);
            nioDecMessageBuf.get(decrypted, 0, count);
            decMessage.release();
            return decrypted;
        });
    }
}

