/*
 * Decompiled with CFR 0.152.
 */
package ratpack.session.store.internal;

import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import ratpack.exec.ExecControl;
import ratpack.exec.Promise;
import ratpack.session.store.SessionStorage;

public class DefaultSessionStorage
implements SessionStorage {
    private final ConcurrentMap<String, Object> store;
    private ExecControl execControl;

    public DefaultSessionStorage(ConcurrentMap<String, Object> store, ExecControl execControl) {
        this.store = store;
        this.execControl = execControl;
    }

    @Override
    public <T> Promise<Optional<T>> get(String key, Class<T> type) {
        return this.execControl.blocking(() -> {
            Object value = this.store.get(key);
            if (value == null) {
                return Optional.empty();
            }
            return Optional.of(type.cast(value));
        });
    }

    @Override
    public Promise<Boolean> set(String key, Object value) {
        return this.execControl.blocking(() -> {
            this.store.put(key, value);
            return true;
        });
    }

    @Override
    public Promise<Integer> remove(String key) {
        return this.execControl.blocking(() -> {
            Object lastValue = this.store.remove(key);
            if (lastValue == null) {
                return 0;
            }
            return 1;
        });
    }

    @Override
    public Promise<Integer> clear() {
        return this.execControl.blocking(() -> {
            this.store.clear();
            return 1;
        });
    }

    @Override
    public Promise<Set<String>> getKeys() {
        return this.execControl.blocking(this.store::keySet);
    }

    public boolean equals(Object o) {
        return this.store.equals(o);
    }

    public int hashCode() {
        return this.store.hashCode();
    }
}

