/*
 * Decompiled with CFR 0.152.
 */
package ratpack.session.clientside.internal;

import com.google.inject.Inject;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.base64.Base64;
import io.netty.handler.codec.base64.Base64Dialect;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Set;
import javax.inject.Provider;
import ratpack.exec.ExecControl;
import ratpack.exec.Operation;
import ratpack.exec.Promise;
import ratpack.http.Request;
import ratpack.http.Response;
import ratpack.session.SessionCookieConfig;
import ratpack.session.SessionStore;
import ratpack.session.clientside.ClientSideSessionConfig;
import ratpack.session.clientside.Crypto;
import ratpack.session.clientside.Signer;

public class ClientSideSessionStore
implements SessionStore {
    private static final String SESSION_SEPARATOR = ":";
    private final ExecControl execControl;
    private final Provider<Request> request;
    private final Provider<Response> response;
    private final Signer signer;
    private final Crypto crypto;
    private final ByteBufAllocator bufferAllocator;
    private final SessionCookieConfig cookieConfig;
    private final ClientSideSessionConfig config;

    @Inject
    public ClientSideSessionStore(ExecControl execControl, Provider<Request> request, Provider<Response> response, Signer signer, Crypto crypto, ByteBufAllocator bufferAllocator, SessionCookieConfig cookieConfig, ClientSideSessionConfig config) {
        this.execControl = execControl;
        this.request = request;
        this.response = response;
        this.signer = signer;
        this.crypto = crypto;
        this.bufferAllocator = bufferAllocator;
        this.cookieConfig = cookieConfig;
        this.config = config;
    }

    @Override
    public Operation store(AsciiString sessionId, ByteBuf sessionData) {
        return this.execControl.operation(() -> {
            int i;
            int oldSessionCookiesCount = this.getCookies(this.config.getSessionCookieName()).length;
            String[] sessionCookiePartitions = this.serialize(sessionData);
            for (i = 0; i < sessionCookiePartitions.length; ++i) {
                this.addCookie(this.config.getSessionCookieName() + "_" + i, sessionCookiePartitions[i]);
            }
            for (i = sessionCookiePartitions.length; i < oldSessionCookiesCount; ++i) {
                this.invalidateCookie(this.config.getSessionCookieName() + "_" + i);
            }
            this.setLastAccessTime();
        });
    }

    @Override
    public Promise<ByteBuf> load(AsciiString sessionId) {
        return this.execControl.promiseFrom(() -> {
            if (!this.isValid()) {
                this.invalidateCookies(this.getCookies(this.config.getSessionCookieName()));
                return Unpooled.buffer((int)0, (int)0);
            }
            this.setLastAccessTime();
            return this.deserialize(this.getCookies(this.config.getSessionCookieName()));
        });
    }

    @Override
    public Operation remove(AsciiString sessionId) {
        return this.execControl.operation(() -> {
            int oldSessionCookiesCount = this.getCookies(this.config.getSessionCookieName()).length;
            for (int i = 0; i < oldSessionCookiesCount; ++i) {
                this.invalidateCookie(this.config.getSessionCookieName() + "_" + i);
            }
        });
    }

    @Override
    public Promise<Long> size() {
        return this.execControl.promiseOf((Object)-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isValid() {
        Cookie[] cookies = this.getCookies(this.config.getLastAccessTimeCookieName());
        if (cookies.length == 0) {
            return false;
        }
        ByteBuf payload = null;
        try {
            long maxInactivityIntervalMillis;
            payload = this.deserialize(cookies);
            if (payload.readableBytes() == 0) {
                this.invalidateCookies(cookies);
                boolean bl = false;
                return bl;
            }
            long lastAccessTime = payload.readLong();
            long currentTime = System.currentTimeMillis();
            if (currentTime - lastAccessTime > (maxInactivityIntervalMillis = this.config.getMaxInactivityInterval().toMillis())) {
                this.invalidateCookies(cookies);
                boolean bl = false;
                return bl;
            }
        }
        finally {
            if (payload != null) {
                payload.release();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLastAccessTime() {
        ByteBuf data = null;
        try {
            int i;
            data = Unpooled.buffer();
            data.writeLong(System.currentTimeMillis());
            int oldCookiesCount = this.getCookies(this.config.getLastAccessTimeCookieName()).length;
            String[] partitions = this.serialize(data);
            for (i = 0; i < partitions.length; ++i) {
                this.addCookie(this.config.getLastAccessTimeCookieName() + "_" + i, partitions[i]);
            }
            for (i = partitions.length; i < oldCookiesCount; ++i) {
                this.invalidateCookie(this.config.getLastAccessTimeCookieName() + "_" + i);
            }
        }
        finally {
            if (data != null) {
                data.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] serialize(ByteBuf sessionData) {
        if (sessionData == null || sessionData.readableBytes() == 0) {
            return new String[0];
        }
        ByteBuf encrypted = null;
        ByteBuf digest = null;
        try {
            encrypted = this.crypto.encrypt(sessionData, this.bufferAllocator);
            String encryptedBase64 = this.toBase64(encrypted);
            digest = this.signer.sign(encrypted.resetReaderIndex(), this.bufferAllocator);
            String digestBase64 = this.toBase64(digest);
            String digestedBase64 = encryptedBase64 + SESSION_SEPARATOR + digestBase64;
            if (digestedBase64.length() <= this.config.getMaxSessionCookieSize()) {
                String[] stringArray = new String[]{digestedBase64};
                return stringArray;
            }
            int count = (int)Math.ceil((double)digestedBase64.length() / (double)this.config.getMaxSessionCookieSize());
            String[] partitions = new String[count];
            for (int i = 0; i < count; ++i) {
                int from = i * this.config.getMaxSessionCookieSize();
                int to = Math.min(from + this.config.getMaxSessionCookieSize(), digestedBase64.length());
                partitions[i] = digestedBase64.substring(from, to);
            }
            String[] stringArray = partitions;
            return stringArray;
        }
        finally {
            if (encrypted != null) {
                encrypted.release();
            }
            if (digest != null) {
                digest.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuf deserialize(Cookie[] sessionCookies) {
        if (sessionCookies.length == 0) {
            return Unpooled.buffer((int)0, (int)0);
        }
        StringBuilder sessionCookie = new StringBuilder();
        for (int i = 0; i < sessionCookies.length; ++i) {
            sessionCookie.append(sessionCookies[i].value());
        }
        String[] parts = sessionCookie.toString().split(SESSION_SEPARATOR);
        if (parts.length != 2) {
            return Unpooled.buffer((int)0, (int)0);
        }
        ByteBuf payload = null;
        ByteBuf digest = null;
        ByteBuf expectedDigest = null;
        ByteBuf decryptedPayload = null;
        try {
            payload = this.fromBase64(this.bufferAllocator, parts[0]);
            digest = this.fromBase64(this.bufferAllocator, parts[1]);
            expectedDigest = this.signer.sign(payload, this.bufferAllocator);
            decryptedPayload = ByteBufUtil.equals((ByteBuf)digest, (ByteBuf)expectedDigest) ? this.crypto.decrypt(payload.resetReaderIndex(), this.bufferAllocator) : Unpooled.buffer((int)0, (int)0);
        }
        finally {
            if (payload != null) {
                payload.release();
            }
            if (digest != null) {
                digest.release();
            }
            if (expectedDigest != null) {
                expectedDigest.release();
            }
        }
        return decryptedPayload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String toBase64(ByteBuf byteBuf) {
        ByteBuf encoded = Base64.encode((ByteBuf)byteBuf, (boolean)false, (Base64Dialect)Base64Dialect.STANDARD);
        try {
            String string = encoded.toString(CharsetUtil.ISO_8859_1);
            return string;
        }
        finally {
            encoded.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuf fromBase64(ByteBufAllocator bufferAllocator, String string) {
        ByteBuf byteBuf = ByteBufUtil.encodeString((ByteBufAllocator)bufferAllocator, (CharBuffer)CharBuffer.wrap(string), (Charset)CharsetUtil.ISO_8859_1);
        try {
            ByteBuf byteBuf2 = Base64.decode((ByteBuf)byteBuf, (Base64Dialect)Base64Dialect.STANDARD);
            return byteBuf2;
        }
        finally {
            byteBuf.release();
        }
    }

    private Cookie[] getCookies(String startsWith) {
        Set cookies = ((Request)this.request.get()).getCookies();
        if (cookies == null || cookies.size() == 0) {
            return new Cookie[0];
        }
        return (Cookie[])cookies.stream().filter(c -> c.name().startsWith(startsWith)).sorted((c1, c2) -> c1.name().compareTo(c2.name())).toArray(Cookie[]::new);
    }

    private void invalidateCookies(Cookie[] cookies) {
        for (int i = 0; i < cookies.length; ++i) {
            this.invalidateCookie(cookies[i].name());
        }
    }

    private void invalidateCookie(String cookieName) {
        Cookie cookie = ((Response)this.response.get()).expireCookie(cookieName);
        if (this.cookieConfig.getPath() != null) {
            cookie.setPath(this.cookieConfig.getPath());
        }
        if (this.cookieConfig.getDomain() != null) {
            cookie.setDomain(this.cookieConfig.getDomain());
        }
        cookie.setHttpOnly(this.cookieConfig.isHttpOnly());
        cookie.setSecure(this.cookieConfig.isSecure());
    }

    private void addCookie(String name, String value) {
        long expirySeconds;
        Cookie cookie = ((Response)this.response.get()).cookie(name, value);
        if (this.cookieConfig.getPath() != null) {
            cookie.setPath(this.cookieConfig.getPath());
        }
        if (this.cookieConfig.getDomain() != null) {
            cookie.setDomain(this.cookieConfig.getDomain());
        }
        long l = expirySeconds = this.cookieConfig.getExpires() == null ? 0L : this.cookieConfig.getExpires().getSeconds();
        if (expirySeconds > 0L) {
            cookie.setMaxAge(expirySeconds);
        }
        cookie.setHttpOnly(this.cookieConfig.isHttpOnly());
        cookie.setSecure(this.cookieConfig.isSecure());
    }
}

