/*
 * Decompiled with CFR 0.152.
 */
package ratpack.session.internal;

import io.netty.handler.codec.http.Cookie;
import io.netty.handler.codec.http.DefaultCookie;
import ratpack.handling.Context;
import ratpack.session.Session;
import ratpack.session.SessionManager;

public class RequestSessionManager {
    private static final String COOKIE_NAME = "JSESSIONID";
    private final Context context;
    private final SessionManager sessionManager;
    private String cookieSessionId;
    private String assignedCookieId;

    public RequestSessionManager(Context context, SessionManager sessionManager) {
        this.context = context;
        this.sessionManager = sessionManager;
    }

    private String getCookieSessionId() {
        if (this.cookieSessionId == null) {
            Cookie match = null;
            for (Cookie cookie : this.context.getRequest().getCookies()) {
                if (!cookie.getName().equals(COOKIE_NAME)) continue;
                match = cookie;
                break;
            }
            this.cookieSessionId = match != null ? match.getValue() : "";
        }
        return this.cookieSessionId.equals("") ? null : this.cookieSessionId;
    }

    public Session getSession() {
        return new Session(){

            @Override
            public String getId() {
                return RequestSessionManager.this.getSessionIdOrInit();
            }

            @Override
            public String getExistingId() {
                return RequestSessionManager.this.getCookieSessionId();
            }

            @Override
            public String regen() {
                String existingId = this.getExistingId();
                if (existingId != null) {
                    RequestSessionManager.this.sessionManager.notifySessionTerminated(existingId);
                }
                return RequestSessionManager.this.assignId();
            }

            @Override
            public void terminate() {
                String existingId = this.getExistingId();
                if (existingId == null) {
                    throw new IllegalStateException("Cannot terminate inactive session");
                }
                RequestSessionManager.this.sessionManager.notifySessionTerminated(existingId);
                RequestSessionManager.this.setCookie("", 0);
            }
        };
    }

    private String getSessionIdOrInit() {
        if (this.assignedCookieId != null) {
            return this.assignedCookieId;
        }
        String cookieSessionId = this.getCookieSessionId();
        if (cookieSessionId != null) {
            return cookieSessionId;
        }
        this.assignedCookieId = this.assignId();
        return this.assignedCookieId;
    }

    private String assignId() {
        String id = this.sessionManager.getIdGenerator().generateSessionId(this.context.getRequest());
        this.setCookie(id, this.sessionManager.getCookieExpiryMins());
        this.sessionManager.notifySessionInitiated(id);
        return id;
    }

    private void setCookie(String value, int expiryMins) {
        String cookiePath;
        DefaultCookie cookie = new DefaultCookie(COOKIE_NAME, value);
        String cookieDomain = this.sessionManager.getCookieDomain();
        if (cookieDomain != null) {
            cookie.setDomain(cookieDomain);
        }
        if ((cookiePath = this.sessionManager.getCookiePath()) != null) {
            cookie.setPath(cookiePath);
        }
        if (expiryMins > 0) {
            cookie.setMaxAge((long)(expiryMins * 60));
        }
        this.context.getResponse().getCookies().add(cookie);
    }
}

