/*
 * Decompiled with CFR 0.152.
 */
package ratpack.session.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import ratpack.session.JavaSessionSerializer;
import ratpack.util.Exceptions;

public class JavaBuiltinSessionSerializer
implements JavaSessionSerializer {
    @Override
    public <T> void serialize(Class<T> type, T value, OutputStream outputStream) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        objectOutputStream.writeObject(value);
        objectOutputStream.flush();
    }

    @Override
    public <T> T deserialize(Class<T> type, InputStream in) throws IOException {
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(in);
            Object value = objectInputStream.readObject();
            if (type.isInstance(value)) {
                return type.cast(value);
            }
            throw new ClassCastException("Expected to read object of type " + type.getName() + " from string, but got: " + value.getClass().getName());
        }
        catch (ClassNotFoundException e) {
            throw Exceptions.uncheck((Throwable)e);
        }
    }
}

