/*
 * Decompiled with CFR 0.152.
 */
package ratpack.session.clientside.internal;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import ratpack.session.clientside.Crypto;

public class DefaultCrypto
implements Crypto {
    private final SecretKeySpec secretKeySpec;
    private final String algorithm;
    private final boolean isInitializationVectorRequired;

    public DefaultCrypto(byte[] key, String algorithm) {
        String[] parts = algorithm.split("/");
        this.secretKeySpec = new SecretKeySpec(key, parts[0]);
        this.algorithm = algorithm;
        this.isInitializationVectorRequired = parts.length > 1 && !parts[1].equalsIgnoreCase("ECB");
    }

    @Override
    public ByteBuf encrypt(ByteBuf message, ByteBufAllocator allocator) throws InvalidKeyException, NoSuchPaddingException, NoSuchAlgorithmException, BadPaddingException, ShortBufferException, IllegalBlockSizeException {
        Cipher cipher = Cipher.getInstance(this.algorithm);
        cipher.init(1, this.secretKeySpec);
        int blockSize = cipher.getBlockSize();
        int messageLength = message.readableBytes();
        int encMessageLength = cipher.getOutputSize(messageLength);
        ByteBuf paddedMessage = null;
        if (messageLength == encMessageLength && encMessageLength % blockSize != 0) {
            int paddedMessageSize = messageLength + blockSize - messageLength % blockSize;
            paddedMessage = allocator.buffer(paddedMessageSize);
            paddedMessage.setZero(0, paddedMessageSize);
            paddedMessage.setBytes(0, message, messageLength);
            paddedMessage.writerIndex(paddedMessageSize);
            encMessageLength = cipher.getOutputSize(paddedMessageSize);
        }
        ByteBuf encMessage = allocator.buffer(encMessageLength);
        ByteBuffer nioBuffer = encMessage.nioBuffer(0, encMessageLength);
        cipher.doFinal(paddedMessage == null ? message.nioBuffer() : paddedMessage.nioBuffer(), nioBuffer);
        encMessage.writerIndex(encMessageLength);
        if (paddedMessage != null) {
            paddedMessage.release();
        }
        if (this.isInitializationVectorRequired) {
            byte[] ivBytes = cipher.getIV();
            ByteBuf iv = allocator.buffer(1 + ivBytes.length);
            iv.writeByte(ivBytes.length).writeBytes(ivBytes);
            return Unpooled.wrappedBuffer((int)2, (ByteBuf[])new ByteBuf[]{iv, encMessage});
        }
        return encMessage;
    }

    @Override
    public ByteBuf decrypt(ByteBuf message, ByteBufAllocator allocator) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, ShortBufferException, IllegalBlockSizeException {
        Cipher cipher = Cipher.getInstance(this.algorithm);
        if (this.isInitializationVectorRequired) {
            byte ivByteLength = message.readByte();
            byte[] iv = new byte[ivByteLength];
            message.readBytes(iv);
            cipher.init(2, (Key)this.secretKeySpec, new IvParameterSpec(iv));
        } else {
            cipher.init(2, this.secretKeySpec);
        }
        int messageLength = message.readableBytes();
        ByteBuf decMessage = allocator.buffer(cipher.getOutputSize(messageLength));
        int count = cipher.doFinal(message.readBytes(messageLength).nioBuffer(), decMessage.nioBuffer(0, messageLength));
        for (int i = count - 1; i >= 0 && decMessage.getByte(i) == 0; --i) {
            --count;
        }
        decMessage.writerIndex(count);
        return decMessage;
    }
}

