/*
 * Decompiled with CFR 0.152.
 */
package ratpack.session.clientside;

import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.time.Duration;
import ratpack.api.Nullable;

public class ClientSideSessionConfig {
    private static final String LAST_ACCESS_TIME_TOKEN = "ratpack_lat";
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();
    private String sessionCookieName = "ratpack_session";
    private String secretToken = ClientSideSessionConfig.randomString(64);
    private String macAlgorithm = "HmacSHA1";
    private String secretKey = ClientSideSessionConfig.randomString(16);
    private String cipherAlgorithm = "AES/CBC/PKCS5Padding";
    private int maxSessionCookieSize = 1932;
    private Duration maxInactivityInterval = Duration.ofHours(24L);

    private static String randomString(int byteLength) {
        byte[] bytes = new byte[byteLength];
        SECURE_RANDOM.nextBytes(bytes);
        return new String(bytes, StandardCharsets.ISO_8859_1);
    }

    public String getSessionCookieName() {
        return this.sessionCookieName;
    }

    public void setSessionCookieName(String sessionCookieName) {
        this.sessionCookieName = sessionCookieName;
    }

    public String getLastAccessTimeCookieName() {
        return LAST_ACCESS_TIME_TOKEN;
    }

    public String getSecretToken() {
        return this.secretToken;
    }

    public void setSecretToken(String secretToken) {
        this.secretToken = secretToken;
    }

    public String getMacAlgorithm() {
        return this.macAlgorithm;
    }

    public void setMacAlgorithm(String macAlgorithm) {
        this.macAlgorithm = macAlgorithm;
    }

    @Nullable
    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(@Nullable String secretKey) {
        this.secretKey = secretKey;
    }

    @Nullable
    public String getCipherAlgorithm() {
        return this.cipherAlgorithm;
    }

    public void setCipherAlgorithm(@Nullable String cipherAlgorithm) {
        this.cipherAlgorithm = cipherAlgorithm;
    }

    public int getMaxSessionCookieSize() {
        return this.maxSessionCookieSize;
    }

    public void setMaxSessionCookieSize(int maxSessionCookieSize) {
        this.maxSessionCookieSize = maxSessionCookieSize < 1024 || maxSessionCookieSize > 4096 ? 2048 : maxSessionCookieSize;
    }

    public Duration getMaxInactivityInterval() {
        return this.maxInactivityInterval;
    }

    public void setMaxInactivityInterval(Duration maxInactivityInterval) {
        this.maxInactivityInterval = maxInactivityInterval;
    }
}

