/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex;

import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.disposables.SequentialDisposable;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.TimeUnit;

public abstract class Scheduler {
    static final long CLOCK_DRIFT_TOLERANCE_NANOSECONDS = TimeUnit.MINUTES.toNanos(Long.getLong("rx2.scheduler.drift-tolerance", 15L));

    public abstract Worker createWorker();

    public long now(TimeUnit unit) {
        return unit.convert(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    public void start() {
    }

    public void shutdown() {
    }

    public Disposable scheduleDirect(Runnable run) {
        return this.scheduleDirect(run, 0L, TimeUnit.NANOSECONDS);
    }

    public Disposable scheduleDirect(Runnable run, long delay, TimeUnit unit) {
        final Worker w = this.createWorker();
        final Runnable decoratedRun = RxJavaPlugins.onSchedule(run);
        w.schedule(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    decoratedRun.run();
                }
                finally {
                    w.dispose();
                }
            }
        }, delay, unit);
        return w;
    }

    public Disposable schedulePeriodicallyDirect(Runnable run, long initialDelay, long period, TimeUnit unit) {
        Worker w = this.createWorker();
        Runnable decoratedRun = RxJavaPlugins.onSchedule(run);
        PeriodicDirectTask periodicTask = new PeriodicDirectTask(decoratedRun, w);
        w.schedulePeriodically(periodicTask, initialDelay, period, unit);
        return periodicTask;
    }

    static class PeriodicDirectTask
    implements Runnable,
    Disposable {
        final Runnable run;
        final Worker worker;
        volatile boolean disposed;

        public PeriodicDirectTask(Runnable run, Worker worker) {
            this.run = run;
            this.worker = worker;
        }

        @Override
        public void run() {
            if (!this.disposed) {
                try {
                    this.run.run();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    this.worker.dispose();
                    throw Exceptions.propagate(ex);
                }
            }
        }

        @Override
        public void dispose() {
            this.disposed = true;
            this.worker.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.disposed;
        }
    }

    public static abstract class Worker
    implements Disposable {
        public Disposable schedule(Runnable run) {
            return this.schedule(run, 0L, TimeUnit.NANOSECONDS);
        }

        public abstract Disposable schedule(Runnable var1, long var2, TimeUnit var4);

        public Disposable schedulePeriodically(Runnable run, long initialDelay, long period, TimeUnit unit) {
            SequentialDisposable first = new SequentialDisposable();
            final SequentialDisposable sd = new SequentialDisposable(first);
            final Runnable decoratedRun = RxJavaPlugins.onSchedule(run);
            final long periodInNanoseconds = unit.toNanos(period);
            final long firstNowNanoseconds = this.now(TimeUnit.NANOSECONDS);
            final long firstStartInNanoseconds = firstNowNanoseconds + unit.toNanos(initialDelay);
            first.replace(this.schedule(new Runnable(){
                long count;
                long lastNowNanoseconds;
                long startInNanoseconds;
                {
                    this.lastNowNanoseconds = firstNowNanoseconds;
                    this.startInNanoseconds = firstStartInNanoseconds;
                }

                @Override
                public void run() {
                    decoratedRun.run();
                    if (!sd.isDisposed()) {
                        long nextTick;
                        long nowNanoseconds = Worker.this.now(TimeUnit.NANOSECONDS);
                        if (nowNanoseconds + CLOCK_DRIFT_TOLERANCE_NANOSECONDS < this.lastNowNanoseconds || nowNanoseconds >= this.lastNowNanoseconds + periodInNanoseconds + CLOCK_DRIFT_TOLERANCE_NANOSECONDS) {
                            nextTick = nowNanoseconds + periodInNanoseconds;
                            this.startInNanoseconds = nextTick - periodInNanoseconds * ++this.count;
                        } else {
                            nextTick = this.startInNanoseconds + ++this.count * periodInNanoseconds;
                        }
                        this.lastNowNanoseconds = nowNanoseconds;
                        long delay = nextTick - nowNanoseconds;
                        sd.replace(Worker.this.schedule(this, delay, TimeUnit.NANOSECONDS));
                    }
                }
            }, initialDelay, unit));
            return sd;
        }

        public long now(TimeUnit unit) {
            return unit.convert(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }
    }
}

