/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.disposables;

import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.disposables.DisposableContainer;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.util.OpenHashSet;
import java.util.ArrayList;

public final class CompositeDisposable
implements Disposable,
DisposableContainer {
    OpenHashSet<Disposable> resources;
    volatile boolean disposed;

    public CompositeDisposable() {
    }

    public CompositeDisposable(Disposable ... resources) {
        ObjectHelper.requireNonNull(resources, "resources is null");
        this.resources = new OpenHashSet(resources.length + 1);
        for (Disposable d : resources) {
            ObjectHelper.requireNonNull(d, "Disposable item is null");
            this.resources.add(d);
        }
    }

    public CompositeDisposable(Iterable<? extends Disposable> resources) {
        ObjectHelper.requireNonNull(resources, "resources is null");
        for (Disposable disposable : resources) {
            ObjectHelper.requireNonNull(disposable, "Disposable item is null");
            this.resources.add(disposable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        OpenHashSet<Disposable> set;
        if (this.disposed) {
            return;
        }
        CompositeDisposable compositeDisposable = this;
        synchronized (compositeDisposable) {
            if (this.disposed) {
                return;
            }
            this.disposed = true;
            set = this.resources;
            this.resources = null;
        }
        this.dispose(set);
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(Disposable d) {
        ObjectHelper.requireNonNull(d, "d is null");
        if (!this.disposed) {
            CompositeDisposable compositeDisposable = this;
            synchronized (compositeDisposable) {
                if (!this.disposed) {
                    OpenHashSet<Disposable> set = this.resources;
                    if (set == null) {
                        this.resources = set = new OpenHashSet();
                    }
                    set.add(d);
                    return true;
                }
            }
        }
        d.dispose();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(Disposable ... ds) {
        ObjectHelper.requireNonNull(ds, "ds is null");
        if (!this.disposed) {
            CompositeDisposable compositeDisposable = this;
            synchronized (compositeDisposable) {
                if (!this.disposed) {
                    OpenHashSet<Disposable> set = this.resources;
                    if (set == null) {
                        set = new OpenHashSet(ds.length + 1);
                        this.resources = set;
                    }
                    for (Disposable d : ds) {
                        ObjectHelper.requireNonNull(d, "d is null");
                        set.add(d);
                    }
                    return true;
                }
            }
        }
        for (Disposable d : ds) {
            d.dispose();
        }
        return false;
    }

    @Override
    public boolean remove(Disposable d) {
        if (this.delete(d)) {
            d.dispose();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(Disposable d) {
        ObjectHelper.requireNonNull(d, "Disposable item is null");
        if (this.disposed) {
            return false;
        }
        CompositeDisposable compositeDisposable = this;
        synchronized (compositeDisposable) {
            if (this.disposed) {
                return false;
            }
            OpenHashSet<Disposable> set = this.resources;
            if (set == null || !set.remove(d)) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        OpenHashSet<Disposable> set;
        if (this.disposed) {
            return;
        }
        CompositeDisposable compositeDisposable = this;
        synchronized (compositeDisposable) {
            if (this.disposed) {
                return;
            }
            set = this.resources;
            this.resources = null;
        }
        this.dispose(set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        if (this.disposed) {
            return 0;
        }
        CompositeDisposable compositeDisposable = this;
        synchronized (compositeDisposable) {
            if (this.disposed) {
                return 0;
            }
            return this.resources.size();
        }
    }

    void dispose(OpenHashSet<Disposable> set) {
        Object[] array;
        if (set == null) {
            return;
        }
        ArrayList<Throwable> errors = null;
        for (Object o : array = set.keys()) {
            if (!(o instanceof Disposable)) continue;
            try {
                ((Disposable)o).dispose();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                if (errors == null) {
                    errors = new ArrayList<Throwable>();
                }
                errors.add(ex);
            }
        }
        if (errors != null) {
            if (errors.size() == 1) {
                throw Exceptions.propagate((Throwable)errors.get(0));
            }
            throw new CompositeException((Iterable<? extends Throwable>)errors);
        }
    }
}

