/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.functions;

import io.reactivex.functions.BiPredicate;

public enum ObjectHelper {

    static final BiPredicate<Object, Object> EQUALS = new BiPredicate<Object, Object>(){

        @Override
        public boolean test(Object o1, Object o2) {
            return ObjectHelper.equals(o1, o2);
        }
    };

    public static <T> T requireNonNull(T object, String message) {
        if (object == null) {
            throw new NullPointerException(message);
        }
        return object;
    }

    public static boolean equals(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o1.equals(o2);
    }

    public static int hashCode(Object o) {
        return o != null ? o.hashCode() : 0;
    }

    public static int compare(int v1, int v2) {
        return v1 < v2 ? -1 : (v1 > v2 ? 1 : 0);
    }

    public static int compare(long v1, long v2) {
        return v1 < v2 ? -1 : (v1 > v2 ? 1 : 0);
    }

    public static <T> BiPredicate<T, T> equalsPredicate() {
        return EQUALS;
    }
}

