/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.single;

import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.disposables.EmptyDisposable;
import java.util.concurrent.Callable;

public final class SingleError<T>
extends Single<T> {
    final Callable<? extends Throwable> errorSupplier;

    public SingleError(Callable<? extends Throwable> errorSupplier) {
        this.errorSupplier = errorSupplier;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super T> s) {
        Throwable error;
        try {
            error = this.errorSupplier.call();
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            error = e;
        }
        if (error == null) {
            error = new NullPointerException();
        }
        EmptyDisposable.error(error, s);
    }
}

