/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.schedulers;

import io.reactivex.internal.schedulers.RxThreadFactory;
import io.reactivex.internal.util.SuppressAnimalSniffer;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public enum SchedulerPoolFactory {

    static final String PURGE_ENABLED_KEY = "rx2.purge-enabled";
    public static final boolean PURGE_ENABLED;
    static final String PURGE_PERIOD_SECONDS_KEY = "rx2.purge-period-seconds";
    public static final int PURGE_PERIOD_SECONDS;
    static final AtomicReference<ScheduledExecutorService> PURGE_THREAD;
    static final ConcurrentHashMap<ScheduledThreadPoolExecutor, Object> POOLS;

    public static void start() {
        ScheduledExecutorService curr;
        while ((curr = PURGE_THREAD.get()) == null || curr.isShutdown()) {
            ScheduledExecutorService next = Executors.newScheduledThreadPool(1, new RxThreadFactory("RxSchedulerPurge"));
            if (PURGE_THREAD.compareAndSet(curr, next)) {
                next.scheduleAtFixedRate(new Runnable(){

                    @Override
                    @SuppressAnimalSniffer
                    public void run() {
                        try {
                            for (ScheduledThreadPoolExecutor e : new ArrayList(POOLS.keySet())) {
                                if (e.isShutdown()) {
                                    POOLS.remove(e);
                                    continue;
                                }
                                e.purge();
                            }
                        }
                        catch (Throwable e) {
                            RxJavaPlugins.onError(e);
                        }
                    }
                }, PURGE_PERIOD_SECONDS, PURGE_PERIOD_SECONDS, TimeUnit.SECONDS);
                return;
            }
            next.shutdownNow();
        }
        return;
    }

    public static void shutdown() {
        PURGE_THREAD.get().shutdownNow();
        POOLS.clear();
    }

    public static ScheduledExecutorService create(ThreadFactory factory) {
        ScheduledExecutorService exec = Executors.newScheduledThreadPool(1, factory);
        if (exec instanceof ScheduledThreadPoolExecutor) {
            ScheduledThreadPoolExecutor e = (ScheduledThreadPoolExecutor)exec;
            POOLS.put(e, exec);
        }
        return exec;
    }

    static {
        PURGE_THREAD = new AtomicReference();
        POOLS = new ConcurrentHashMap();
        boolean purgeEnable = true;
        int purgePeriod = 1;
        Properties properties = System.getProperties();
        if (properties.containsKey(PURGE_ENABLED_KEY) && (purgeEnable = Boolean.getBoolean(PURGE_ENABLED_KEY)) && properties.containsKey(PURGE_PERIOD_SECONDS_KEY)) {
            purgePeriod = Integer.getInteger(PURGE_PERIOD_SECONDS_KEY, purgePeriod);
        }
        PURGE_ENABLED = purgeEnable;
        PURGE_PERIOD_SECONDS = purgePeriod;
        SchedulerPoolFactory.start();
    }
}

