/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.subscribers.observable;

import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicReference;

public final class LambdaObserver<T>
extends AtomicReference<Disposable>
implements Observer<T>,
Disposable {
    private static final long serialVersionUID = -7251123623727029452L;
    final Consumer<? super T> onNext;
    final Consumer<? super Throwable> onError;
    final Action onComplete;
    final Consumer<? super Disposable> onSubscribe;

    public LambdaObserver(Consumer<? super T> onNext, Consumer<? super Throwable> onError, Action onComplete, Consumer<? super Disposable> onSubscribe) {
        this.onNext = onNext;
        this.onError = onError;
        this.onComplete = onComplete;
        this.onSubscribe = onSubscribe;
    }

    @Override
    public void onSubscribe(Disposable s) {
        if (DisposableHelper.setOnce(this, s)) {
            try {
                this.onSubscribe.accept(this);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                s.dispose();
                RxJavaPlugins.onError(ex);
            }
        }
    }

    @Override
    public void onNext(T t) {
        try {
            this.onNext.accept(t);
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            this.onError(e);
        }
    }

    @Override
    public void onError(Throwable t) {
        this.dispose();
        try {
            this.onError.accept(t);
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            RxJavaPlugins.onError(e);
            RxJavaPlugins.onError(t);
        }
    }

    @Override
    public void onComplete() {
        this.dispose();
        try {
            this.onComplete.run();
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            RxJavaPlugins.onError(e);
        }
    }

    @Override
    public void dispose() {
        DisposableHelper.dispose(this);
    }

    @Override
    public boolean isDisposed() {
        return this.get() == DisposableHelper.DISPOSED;
    }
}

