/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.subscriptions;

import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscription;

public final class AsyncSubscription
extends AtomicLong
implements Subscription,
Disposable {
    private static final long serialVersionUID = 7028635084060361255L;
    final AtomicReference<Subscription> actual;
    final AtomicReference<Disposable> resource = new AtomicReference();

    public AsyncSubscription() {
        this.actual = new AtomicReference();
    }

    public AsyncSubscription(Disposable resource) {
        this();
        this.resource.lazySet(resource);
    }

    public void request(long n) {
        Subscription s = this.actual.get();
        if (s != null) {
            s.request(n);
        } else if (SubscriptionHelper.validate(n)) {
            long mr;
            BackpressureHelper.add(this, n);
            s = this.actual.get();
            if (s != null && (mr = this.getAndSet(0L)) != 0L) {
                s.request(mr);
            }
        }
    }

    public void cancel() {
        this.dispose();
    }

    @Override
    public void dispose() {
        SubscriptionHelper.cancel(this.actual);
        DisposableHelper.dispose(this.resource);
    }

    @Override
    public boolean isDisposed() {
        return this.actual.get() == SubscriptionHelper.CANCELLED;
    }

    public boolean setResource(Disposable r) {
        return DisposableHelper.set(this.resource, r);
    }

    public boolean replaceResource(Disposable r) {
        return DisposableHelper.replace(this.resource, r);
    }

    public boolean setSubscription(Subscription s) {
        do {
            Subscription a;
            if ((a = this.actual.get()) == SubscriptionHelper.CANCELLED) {
                s.cancel();
                return false;
            }
            if (a == null) continue;
            s.cancel();
            SubscriptionHelper.reportSubscriptionSet();
            return true;
        } while (!this.actual.compareAndSet(null, s));
        long mr = this.getAndSet(0L);
        if (mr != 0L) {
            s.request(mr);
        }
        return true;
    }
}

