/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.subscriptions.DeferredScalarSubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import java.util.NoSuchElementException;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableSingle<T>
extends AbstractFlowableWithUpstream<T, T> {
    final T defaultValue;

    public FlowableSingle(Publisher<T> source, T defaultValue) {
        super(source);
        this.defaultValue = defaultValue;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        this.source.subscribe(new SingleElementSubscriber<T>(s, this.defaultValue));
    }

    static final class SingleElementSubscriber<T>
    extends DeferredScalarSubscription<T>
    implements Subscriber<T> {
        private static final long serialVersionUID = -5526049321428043809L;
        final T defaultValue;
        Subscription s;
        boolean done;

        public SingleElementSubscriber(Subscriber<? super T> actual, T defaultValue) {
            super(actual);
            this.defaultValue = defaultValue;
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
            if (this.done) {
                return;
            }
            if (this.value != null) {
                this.done = true;
                this.s.cancel();
                this.actual.onError((Throwable)new IllegalArgumentException("Sequence contains more than one element!"));
                return;
            }
            this.value = t;
        }

        public void onError(Throwable t) {
            if (this.done) {
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            Object v = this.value;
            this.value = null;
            if (v == null) {
                v = this.defaultValue;
            }
            if (v == null) {
                this.actual.onError((Throwable)new NoSuchElementException());
            } else {
                this.complete(v);
            }
        }

        @Override
        public void cancel() {
            super.cancel();
            this.s.cancel();
        }
    }
}

