/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableOnErrorReturn<T>
extends AbstractFlowableWithUpstream<T, T> {
    final Function<? super Throwable, ? extends T> valueSupplier;

    public FlowableOnErrorReturn(Publisher<T> source, Function<? super Throwable, ? extends T> valueSupplier) {
        super(source);
        this.valueSupplier = valueSupplier;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        this.source.subscribe(new OnErrorReturnSubscriber<T>(s, this.valueSupplier));
    }

    static final class OnErrorReturnSubscriber<T>
    extends AtomicLong
    implements Subscriber<T>,
    Subscription {
        private static final long serialVersionUID = -3740826063558713822L;
        final Subscriber<? super T> actual;
        final Function<? super Throwable, ? extends T> valueSupplier;
        Subscription s;
        final AtomicInteger state = new AtomicInteger();
        T value;
        volatile boolean done;
        static final int NO_REQUEST_NO_VALUE = 0;
        static final int NO_REQUEST_HAS_VALUE = 1;
        static final int HAS_REQUEST_NO_VALUE = 2;
        static final int HAS_REQUEST_HAS_VALUE = 3;

        OnErrorReturnSubscriber(Subscriber<? super T> actual, Function<? super Throwable, ? extends T> valueSupplier) {
            this.actual = actual;
            this.valueSupplier = valueSupplier;
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            this.actual.onNext(t);
            if (this.get() != Long.MAX_VALUE) {
                this.decrementAndGet();
            }
        }

        public void onError(Throwable t) {
            T v;
            this.done = true;
            try {
                v = this.valueSupplier.apply(t);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.state.lazySet(3);
                this.actual.onError((Throwable)new CompositeException(e, t));
                return;
            }
            if (v == null) {
                this.state.lazySet(3);
                NullPointerException npe = new NullPointerException("The supplied value is null");
                npe.initCause(t);
                this.actual.onError((Throwable)npe);
                return;
            }
            if (this.get() == 0L) {
                while (true) {
                    int s;
                    if ((s = this.state.get()) == 2) {
                        if (!this.state.compareAndSet(s, 3)) continue;
                        this.actual.onNext(v);
                        this.actual.onComplete();
                        return;
                    }
                    if (s == 1) {
                        return;
                    }
                    if (s == 3) {
                        this.value = null;
                        return;
                    }
                    this.value = v;
                    if (this.state.compareAndSet(s, 1)) break;
                }
                return;
            }
            this.state.lazySet(3);
            this.actual.onNext(v);
            this.actual.onComplete();
        }

        public void onComplete() {
            this.state.lazySet(3);
            this.actual.onComplete();
        }

        public void request(long n) {
            if (!SubscriptionHelper.validate(n)) {
                return;
            }
            BackpressureHelper.add(this, n);
            if (this.done) {
                while (true) {
                    int s;
                    if ((s = this.state.get()) == 1) {
                        if (!this.state.compareAndSet(s, 3)) continue;
                        T v = this.value;
                        this.value = null;
                        this.actual.onNext(v);
                        this.actual.onComplete();
                        return;
                    }
                    if (s == 2 || s == 3) {
                        return;
                    }
                    if (this.state.compareAndSet(s, 2)) break;
                }
                return;
            }
            this.s.request(n);
        }

        public void cancel() {
            this.state.lazySet(3);
            this.s.cancel();
        }
    }
}

