/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.maybe;

import io.reactivex.Maybe;
import io.reactivex.MaybeObserver;
import io.reactivex.disposables.Disposables;
import io.reactivex.exceptions.Exceptions;
import java.util.concurrent.Callable;

public final class MaybeErrorCallable<T>
extends Maybe<T> {
    final Callable<? extends Throwable> errorSupplier;

    public MaybeErrorCallable(Callable<? extends Throwable> errorSupplier) {
        this.errorSupplier = errorSupplier;
    }

    @Override
    protected void subscribeActual(MaybeObserver<? super T> observer) {
        Throwable ex;
        observer.onSubscribe(Disposables.disposed());
        try {
            ex = this.errorSupplier.call();
        }
        catch (Throwable ex1) {
            Exceptions.throwIfFatal(ex1);
            ex = ex1;
        }
        if (ex == null) {
            ex = new NullPointerException("Callable returned null throwable. Null values are generally not allowed in 2.x operators and sources.");
        }
        observer.onError(ex);
    }
}

