/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.internal.operators.observable.ObservableScalarXMap;
import io.reactivex.internal.queue.SpscArrayQueue;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableSwitchMap<T, R>
extends AbstractObservableWithUpstream<T, R> {
    final Function<? super T, ? extends ObservableSource<? extends R>> mapper;
    final int bufferSize;
    final boolean delayErrors;

    public ObservableSwitchMap(ObservableSource<T> source, Function<? super T, ? extends ObservableSource<? extends R>> mapper, int bufferSize, boolean delayErrors) {
        super(source);
        this.mapper = mapper;
        this.bufferSize = bufferSize;
        this.delayErrors = delayErrors;
    }

    @Override
    public void subscribeActual(Observer<? super R> t) {
        if (ObservableScalarXMap.tryScalarXMapSubscribe(this.source, t, this.mapper)) {
            return;
        }
        this.source.subscribe(new SwitchMapObserver<T, R>(t, this.mapper, this.bufferSize, this.delayErrors));
    }

    static final class SwitchMapInnerObserver<T, R>
    extends AtomicReference<Disposable>
    implements Observer<R> {
        private static final long serialVersionUID = 3837284832786408377L;
        final SwitchMapObserver<T, R> parent;
        final long index;
        final SpscArrayQueue<R> queue;
        volatile boolean done;

        SwitchMapInnerObserver(SwitchMapObserver<T, R> parent, long index, int bufferSize) {
            this.parent = parent;
            this.index = index;
            this.queue = new SpscArrayQueue(bufferSize);
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (this.index == this.parent.unique) {
                DisposableHelper.setOnce(this, s);
            } else {
                s.dispose();
            }
        }

        @Override
        public void onNext(R t) {
            if (this.index == this.parent.unique) {
                if (!this.queue.offer(t)) {
                    this.onError(new IllegalStateException("Queue full?!"));
                    return;
                }
                this.parent.drain();
            }
        }

        @Override
        public void onError(Throwable t) {
            this.parent.innerError(this, t);
        }

        @Override
        public void onComplete() {
            if (this.index == this.parent.unique) {
                this.done = true;
                this.parent.drain();
            }
        }

        public void cancel() {
            DisposableHelper.dispose(this);
        }
    }

    static final class SwitchMapObserver<T, R>
    extends AtomicInteger
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = -3491074160481096299L;
        final Observer<? super R> actual;
        final Function<? super T, ? extends ObservableSource<? extends R>> mapper;
        final int bufferSize;
        final boolean delayErrors;
        final AtomicThrowable errors;
        volatile boolean done;
        volatile boolean cancelled;
        Disposable s;
        final AtomicReference<SwitchMapInnerObserver<T, R>> active = new AtomicReference();
        static final SwitchMapInnerObserver<Object, Object> CANCELLED = new SwitchMapInnerObserver(null, -1L, 1);
        volatile long unique;

        SwitchMapObserver(Observer<? super R> actual, Function<? super T, ? extends ObservableSource<? extends R>> mapper, int bufferSize, boolean delayErrors) {
            this.actual = actual;
            this.mapper = mapper;
            this.bufferSize = bufferSize;
            this.delayErrors = delayErrors;
            this.errors = new AtomicThrowable();
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (DisposableHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            ObservableSource<R> p;
            long c;
            this.unique = c = this.unique + 1L;
            SwitchMapInnerObserver<T, R> inner = this.active.get();
            if (inner != null) {
                inner.cancel();
            }
            try {
                p = this.mapper.apply(t);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.s.dispose();
                this.onError(e);
                return;
            }
            if (p == null) {
                this.s.dispose();
                this.onError(new NullPointerException("The publisher returned is null"));
                return;
            }
            SwitchMapInnerObserver nextInner = new SwitchMapInnerObserver(this, c, this.bufferSize);
            while ((inner = this.active.get()) != CANCELLED) {
                if (!this.active.compareAndSet(inner, nextInner)) continue;
                p.subscribe(nextInner);
                break;
            }
        }

        @Override
        public void onError(Throwable t) {
            if (this.done || !this.errors.addThrowable(t)) {
                if (!this.delayErrors) {
                    this.disposeInner();
                }
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.drain();
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.drain();
        }

        @Override
        public void dispose() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.s.dispose();
                this.disposeInner();
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        void disposeInner() {
            SwitchMapInnerObserver<Object, Object> a = this.active.get();
            if (a != CANCELLED && (a = this.active.getAndSet(CANCELLED)) != CANCELLED && a != null) {
                a.cancel();
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            Observer<R> a = this.actual;
            int missing = 1;
            while (true) {
                SwitchMapInnerObserver<T, R> inner;
                if (this.cancelled) {
                    return;
                }
                if (this.done) {
                    Throwable ex;
                    boolean empty;
                    boolean bl = empty = this.active.get() == null;
                    if (this.delayErrors) {
                        if (empty) {
                            ex = (Throwable)this.errors.get();
                            if (ex != null) {
                                a.onError(ex);
                            } else {
                                a.onComplete();
                            }
                            return;
                        }
                    } else {
                        ex = (Throwable)this.errors.get();
                        if (ex != null) {
                            a.onError(this.errors.terminate());
                            return;
                        }
                        if (empty) {
                            a.onComplete();
                            return;
                        }
                    }
                }
                if ((inner = this.active.get()) != null) {
                    SpscArrayQueue q = inner.queue;
                    if (inner.done) {
                        boolean empty = q.isEmpty();
                        if (this.delayErrors) {
                            if (empty) {
                                this.active.compareAndSet(inner, null);
                                continue;
                            }
                        } else {
                            Throwable ex = (Throwable)this.errors.get();
                            if (ex != null) {
                                a.onError(this.errors.terminate());
                                return;
                            }
                            if (empty) {
                                this.active.compareAndSet(inner, null);
                                continue;
                            }
                        }
                    }
                    boolean retry = false;
                    while (true) {
                        boolean empty;
                        if (this.cancelled) {
                            return;
                        }
                        if (inner != this.active.get()) {
                            retry = true;
                            break;
                        }
                        boolean d = inner.done;
                        Object v = q.poll();
                        boolean bl = empty = v == null;
                        if (d) {
                            if (this.delayErrors || empty) {
                                this.active.compareAndSet(inner, null);
                                retry = true;
                                break;
                            }
                            Throwable ex = (Throwable)this.errors.get();
                            if (ex != null) {
                                a.onError(this.errors.terminate());
                                return;
                            }
                        }
                        if (empty) break;
                        a.onNext(v);
                    }
                    if (retry) continue;
                }
                if ((missing = this.addAndGet(-missing)) == 0) break;
            }
        }

        void innerError(SwitchMapInnerObserver<T, R> inner, Throwable ex) {
            if (inner.index == this.unique && this.errors.addThrowable(ex)) {
                if (!this.delayErrors) {
                    this.s.dispose();
                }
                inner.done = true;
                this.drain();
            } else {
                RxJavaPlugins.onError(ex);
            }
        }

        static {
            CANCELLED.cancel();
        }
    }
}

