/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class ObservableTakeLastTimed<T>
extends AbstractObservableWithUpstream<T, T> {
    final long count;
    final long time;
    final TimeUnit unit;
    final Scheduler scheduler;
    final int bufferSize;
    final boolean delayError;

    public ObservableTakeLastTimed(ObservableSource<T> source, long count, long time, TimeUnit unit, Scheduler scheduler, int bufferSize, boolean delayError) {
        super(source);
        this.count = count;
        this.time = time;
        this.unit = unit;
        this.scheduler = scheduler;
        this.bufferSize = bufferSize;
        this.delayError = delayError;
    }

    @Override
    public void subscribeActual(Observer<? super T> t) {
        this.source.subscribe(new TakeLastTimedObserver<T>(t, this.count, this.time, this.unit, this.scheduler, this.bufferSize, this.delayError));
    }

    static final class TakeLastTimedObserver<T>
    extends AtomicInteger
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = -5677354903406201275L;
        final Observer<? super T> actual;
        final long count;
        final long time;
        final TimeUnit unit;
        final Scheduler scheduler;
        final SpscLinkedArrayQueue<Object> queue;
        final boolean delayError;
        Disposable s;
        volatile boolean cancelled;
        volatile boolean done;
        Throwable error;

        TakeLastTimedObserver(Observer<? super T> actual, long count, long time, TimeUnit unit, Scheduler scheduler, int bufferSize, boolean delayError) {
            this.actual = actual;
            this.count = count;
            this.time = time;
            this.unit = unit;
            this.scheduler = scheduler;
            this.queue = new SpscLinkedArrayQueue(bufferSize);
            this.delayError = delayError;
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (DisposableHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            long ts;
            SpscLinkedArrayQueue<Object> q = this.queue;
            long now = this.scheduler.now(this.unit);
            long time = this.time;
            long c = this.count;
            boolean unbounded = c == Long.MAX_VALUE;
            q.offer(now, t);
            while (!q.isEmpty() && ((ts = ((Long)q.peek()).longValue()) <= now - time || !unbounded && (long)(q.size() >> 1) > c)) {
                q.poll();
                q.poll();
            }
        }

        @Override
        public void onError(Throwable t) {
            this.error = t;
            this.done = true;
            this.drain();
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.drain();
        }

        @Override
        public void dispose() {
            if (this.cancelled) {
                this.cancelled = true;
                if (this.getAndIncrement() == 0) {
                    this.queue.clear();
                    this.s.dispose();
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Observer<Object> a = this.actual;
            SpscLinkedArrayQueue<Object> q = this.queue;
            boolean delayError = this.delayError;
            block0: do {
                if (!this.done) continue;
                boolean empty = q.isEmpty();
                if (this.checkTerminated(empty, a, delayError)) {
                    return;
                }
                while (true) {
                    Object ts;
                    boolean bl = empty = (ts = q.poll()) == null;
                    if (this.checkTerminated(empty, a, delayError)) {
                        return;
                    }
                    if (empty) continue block0;
                    Object o = q.poll();
                    if (o == null) {
                        this.s.dispose();
                        a.onError(new IllegalStateException("Queue empty?!"));
                        return;
                    }
                    if ((Long)ts < this.scheduler.now(this.unit) - this.time) continue;
                    a.onNext(o);
                }
            } while ((missed = this.addAndGet(-missed)) != 0);
        }

        boolean checkTerminated(boolean empty, Observer<? super T> a, boolean delayError) {
            if (this.cancelled) {
                this.queue.clear();
                this.s.dispose();
                return true;
            }
            if (delayError) {
                if (empty) {
                    Throwable e = this.error;
                    if (e != null) {
                        a.onError(e);
                    } else {
                        a.onComplete();
                    }
                    return true;
                }
            } else {
                Throwable e = this.error;
                if (e != null) {
                    this.queue.clear();
                    a.onError(e);
                    return true;
                }
                if (empty) {
                    a.onComplete();
                    return true;
                }
            }
            return false;
        }
    }
}

