/*
 * Decompiled with CFR 0.152.
 */
package rx.javafx.sources;

import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Scene;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.schedulers.JavaFxScheduler;
import rx.subscriptions.JavaFxSubscriptions;

public final class SceneEventSource {
    public static <T extends Event> Observable<T> fromSceneEvents(final Scene source, final EventType<T> eventType) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<T>(){

            public void call(Subscriber<? super T> subscriber) {
                EventHandler handler = arg_0 -> subscriber.onNext(arg_0);
                source.addEventHandler(eventType, handler);
                subscriber.add(JavaFxSubscriptions.unsubscribeInEventDispatchThread(() -> source.removeEventHandler(eventType, handler)));
            }
        }).subscribeOn((Scheduler)JavaFxScheduler.getInstance());
    }
}

