/*
 * Decompiled with CFR 0.152.
 */
package rx.observables;

import java.util.Map;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import rx.Observable;
import rx.functions.Func1;
import rx.javafx.sources.ActionEventSource;
import rx.javafx.sources.Change;
import rx.javafx.sources.ListChange;
import rx.javafx.sources.MapChange;
import rx.javafx.sources.NodeEventSource;
import rx.javafx.sources.ObservableListSource;
import rx.javafx.sources.ObservableMapSource;
import rx.javafx.sources.ObservableSetSource;
import rx.javafx.sources.ObservableValueSource;
import rx.javafx.sources.SceneEventSource;
import rx.javafx.sources.SetChange;
import rx.javafx.sources.WindowEventSource;

public enum JavaFxObservable {


    public static <T extends Event> Observable<T> fromNodeEvents(Node node, EventType<T> eventType) {
        return NodeEventSource.fromNodeEvents(node, eventType);
    }

    public static <T> Observable<T> fromObservableValue(ObservableValue<T> fxObservable) {
        return ObservableValueSource.fromObservableValue(fxObservable);
    }

    public static <T> Observable<Change<T>> fromObservableValueChanges(ObservableValue<T> fxObservable) {
        return ObservableValueSource.fromObservableValueChanges(fxObservable);
    }

    public static <T extends Event> Observable<T> fromSceneEvents(Scene scene, EventType<T> eventType) {
        return SceneEventSource.fromSceneEvents(scene, eventType);
    }

    public static <T extends WindowEvent> Observable<T> fromWindowEvents(Window window, EventType<T> eventType) {
        return WindowEventSource.fromWindowEvents(window, eventType);
    }

    public static Observable<ActionEvent> fromActionEvents(Node node) {
        return ActionEventSource.fromActionEvents(node);
    }

    public static Observable<ActionEvent> fromActionEvents(ContextMenu contextMenu) {
        return ActionEventSource.fromActionEvents(contextMenu);
    }

    public static Observable<ActionEvent> fromActionEvents(MenuItem menuItem) {
        return ActionEventSource.fromActionEvents(menuItem);
    }

    public static <T> Observable<ObservableList<T>> fromObservableList(ObservableList<T> source) {
        return ObservableListSource.fromObservableList(source);
    }

    public static <T> Observable<T> fromObservableListAdds(ObservableList<T> source) {
        return ObservableListSource.fromObservableListAdds(source);
    }

    public static <T> Observable<T> fromObservableListRemovals(ObservableList<T> source) {
        return ObservableListSource.fromObservableListRemovals(source);
    }

    public static <T> Observable<T> fromObservableListUpdates(ObservableList<T> source) {
        return ObservableListSource.fromObservableListUpdates(source);
    }

    public static <T> Observable<ListChange<T>> fromObservableListChanges(ObservableList<T> source) {
        return ObservableListSource.fromObservableListChanges(source);
    }

    public static <T> Observable<ListChange<T>> fromObservableListDistinctChanges(ObservableList<T> source) {
        return ObservableListSource.fromObservableListDistinctChanges(source);
    }

    public static <T, R> Observable<ListChange<T>> fromObservableListDistinctChanges(ObservableList<T> source, Func1<T, R> mapper) {
        return ObservableListSource.fromObservableListDistinctChanges(source, mapper);
    }

    public static <T, R> Observable<ListChange<R>> fromObservableListDistinctMappings(ObservableList<T> source, Func1<T, R> mapper) {
        return ObservableListSource.fromObservableListDistinctMappings(source, mapper);
    }

    public static <K, T> Observable<ObservableMap<K, T>> fromObservableMap(ObservableMap<K, T> source) {
        return ObservableMapSource.fromObservableMap(source);
    }

    public static <K, T> Observable<Map.Entry<K, T>> fromObservableMapAdds(ObservableMap<K, T> source) {
        return ObservableMapSource.fromObservableMapAdds(source);
    }

    public static <K, T> Observable<Map.Entry<K, T>> fromObservableMapRemovals(ObservableMap<K, T> source) {
        return ObservableMapSource.fromObservableMapRemovals(source);
    }

    public static <K, T> Observable<MapChange<K, T>> fromObservableMapChanges(ObservableMap<K, T> source) {
        return ObservableMapSource.fromObservableMapChanges(source);
    }

    public static <T> Observable<ObservableSet<T>> fromObservableSet(ObservableSet<T> source) {
        return ObservableSetSource.fromObservableSet(source);
    }

    public static <T> Observable<T> fromObservableSetAdds(ObservableSet<T> source) {
        return ObservableSetSource.fromObservableSetAdds(source);
    }

    public static <T> Observable<T> fromObservableSetRemovals(ObservableSet<T> source) {
        return ObservableSetSource.fromObservableSetRemovals(source);
    }

    public static <T> Observable<SetChange<T>> fromObservableSetChanges(ObservableSet<T> source) {
        return ObservableSetSource.fromObservableSetChanges(source);
    }
}

