/*
 * Decompiled with CFR 0.152.
 */
package rx.javafx.sources;

import java.util.Arrays;
import java.util.HashSet;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;
import rx.Observable;
import rx.annotations.Beta;
import rx.observables.JavaFxObservable;

@Beta
public final class CompositeObservable<T> {
    private final ObservableSet<Observable<T>> sources = FXCollections.synchronizedObservableSet((ObservableSet)FXCollections.observableSet(new HashSet()));
    private final Observable<T> output;

    public CompositeObservable() {
        this(null);
    }

    public CompositeObservable(Observable.Transformer<T, T> transformer) {
        Observable updatingSource = Observable.merge((Observable)Observable.from(this.sources).flatMap(obs -> obs.takeWhile(v -> this.sources.contains(obs))), (Observable)JavaFxObservable.fromObservableSetAdds(this.sources).flatMap(obs -> obs.takeWhile(v -> this.sources.contains(obs))));
        this.output = transformer == null ? updatingSource : updatingSource.compose(transformer);
    }

    public Observable<T> toObservable() {
        return this.output;
    }

    public void add(Observable<T> observable) {
        this.sources.add(observable);
    }

    public void addAll(Observable<T> ... observables) {
        Arrays.stream(observables).forEach(this::add);
    }

    public void remove(Observable<T> observable) {
        this.sources.remove(observable);
    }

    public void removeAll(Observable<T> ... observables) {
        Arrays.stream(observables).forEach(this::remove);
    }

    public void clear() {
        this.sources.clear();
    }

    public ObservableSet<Observable<T>> getSources() {
        return FXCollections.unmodifiableObservableSet(this.sources);
    }
}

