/*
 * Decompiled with CFR 0.152.
 */
package rx.javafx.sources;

import java.util.AbstractMap;
import java.util.Map;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableMap;
import rx.Observable;
import rx.Scheduler;
import rx.javafx.sources.Flag;
import rx.javafx.sources.MapChange;
import rx.schedulers.JavaFxScheduler;
import rx.subscriptions.JavaFxSubscriptions;

public final class ObservableMapSource {
    private ObservableMapSource() {
    }

    public static <K, T> Observable<ObservableMap<K, T>> fromObservableMap(ObservableMap<K, T> source) {
        return Observable.create(subscriber -> {
            MapChangeListener listener = c -> subscriber.onNext((Object)source);
            source.addListener(listener);
            subscriber.add(JavaFxSubscriptions.unsubscribeInEventDispatchThread(() -> source.removeListener(listener)));
        }).startWith(source).subscribeOn((Scheduler)JavaFxScheduler.getInstance());
    }

    public static <K, T> Observable<Map.Entry<K, T>> fromObservableMapAdds(ObservableMap<K, T> source) {
        return Observable.create(subscriber -> {
            MapChangeListener listener = c -> {
                if (c.wasAdded()) {
                    subscriber.onNext(new AbstractMap.SimpleEntry<Object, Object>(c.getKey(), c.getValueAdded()));
                }
            };
            source.addListener(listener);
            subscriber.add(JavaFxSubscriptions.unsubscribeInEventDispatchThread(() -> source.removeListener(listener)));
        }).subscribeOn((Scheduler)JavaFxScheduler.getInstance());
    }

    public static <K, T> Observable<Map.Entry<K, T>> fromObservableMapRemovals(ObservableMap<K, T> source) {
        return Observable.create(subscriber -> {
            MapChangeListener listener = c -> {
                if (c.wasRemoved()) {
                    subscriber.onNext(new AbstractMap.SimpleEntry<Object, Object>(c.getKey(), c.getValueRemoved()));
                }
            };
            source.addListener(listener);
            subscriber.add(JavaFxSubscriptions.unsubscribeInEventDispatchThread(() -> source.removeListener(listener)));
        }).subscribeOn((Scheduler)JavaFxScheduler.getInstance());
    }

    public static <K, T> Observable<MapChange<K, T>> fromObservableMapChanges(ObservableMap<K, T> source) {
        return Observable.create(subscriber -> {
            MapChangeListener listener = c -> {
                if (c.wasRemoved()) {
                    subscriber.onNext(new MapChange<Object, Object>(c.getKey(), c.getValueRemoved(), Flag.REMOVED));
                }
                if (c.wasAdded()) {
                    subscriber.onNext(new MapChange<Object, Object>(c.getKey(), c.getValueAdded(), Flag.ADDED));
                }
            };
            source.addListener(listener);
            subscriber.add(JavaFxSubscriptions.unsubscribeInEventDispatchThread(() -> source.removeListener(listener)));
        }).subscribeOn((Scheduler)JavaFxScheduler.getInstance());
    }
}

