/*
 * Decompiled with CFR 0.152.
 */
package rx.javafx.sources;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import rx.Observable;
import rx.Subscriber;
import rx.javafx.sources.Change;
import rx.subscriptions.JavaFxSubscriptions;

public class ObservableValueSource {
    public static <T> Observable<T> fromObservableValue(final ObservableValue<T> fxObservable) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<T>(){

            public void call(Subscriber<? super T> subscriber) {
                subscriber.onNext(fxObservable.getValue());
                ChangeListener listener = (observableValue, prev, current) -> subscriber.onNext(current);
                fxObservable.addListener(listener);
                subscriber.add(JavaFxSubscriptions.unsubscribeInEventDispatchThread(() -> fxObservable.removeListener(listener)));
            }
        });
    }

    public static <T> Observable<Change<T>> fromObservableValueChanges(final ObservableValue<T> fxObservable) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<Change<T>>(){

            public void call(Subscriber<? super Change<T>> subscriber) {
                ChangeListener listener = (observableValue, prev, current) -> subscriber.onNext(new Change<Object>(prev, current));
                fxObservable.addListener(listener);
                subscriber.add(JavaFxSubscriptions.unsubscribeInEventDispatchThread(() -> fxObservable.removeListener(listener)));
            }
        });
    }
}

