/*
 * Decompiled with CFR 0.152.
 */
package rx.schedulers;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.util.Duration;
import rx.Scheduler;
import rx.Subscription;
import rx.functions.Action0;
import rx.subscriptions.BooleanSubscription;
import rx.subscriptions.CompositeSubscription;
import rx.subscriptions.SerialSubscription;
import rx.subscriptions.Subscriptions;

public final class JavaFxScheduler
extends Scheduler {
    private static final JavaFxScheduler INSTANCE = new JavaFxScheduler();

    JavaFxScheduler() {
    }

    public static JavaFxScheduler getInstance() {
        return INSTANCE;
    }

    private static void assertThatTheDelayIsValidForTheJavaFxTimer(long delay) {
        if (delay < 0L || delay > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(String.format("The JavaFx timer only accepts non-negative delays up to %d milliseconds.", Integer.MAX_VALUE));
        }
    }

    public Scheduler.Worker createWorker() {
        return new InnerJavaFxScheduler();
    }

    private static class InnerJavaFxScheduler
    extends Scheduler.Worker
    implements Runnable {
        private final CompositeSubscription tracking = new CompositeSubscription();
        private final Queue<Runnable> queue = new ConcurrentLinkedQueue<Runnable>();
        private int wip;

        private InnerJavaFxScheduler() {
        }

        public void unsubscribe() {
            this.tracking.unsubscribe();
        }

        public boolean isUnsubscribed() {
            return this.tracking.isUnsubscribed();
        }

        public Subscription schedule(final Action0 action, long delayTime, TimeUnit unit) {
            long delay = Math.max(0L, unit.toMillis(delayTime));
            JavaFxScheduler.assertThatTheDelayIsValidForTheJavaFxTimer(delay);
            class DualAction
            implements EventHandler<ActionEvent>,
            Subscription,
            Runnable {
                private Timeline timeline;
                final SerialSubscription subs = new SerialSubscription();
                boolean nonDelayed;

                DualAction() {
                }

                private void setTimer(Timeline timeline) {
                    this.timeline = timeline;
                }

                public void handle(ActionEvent event) {
                    this.run();
                }

                @Override
                public void run() {
                    if (this.nonDelayed) {
                        try {
                            if (InnerJavaFxScheduler.this.tracking.isUnsubscribed() || this.isUnsubscribed()) {
                                return;
                            }
                            action.call();
                        }
                        finally {
                            this.subs.unsubscribe();
                        }
                    } else {
                        this.timeline.stop();
                        this.timeline = null;
                        this.nonDelayed = true;
                        InnerJavaFxScheduler.this.trampoline(this);
                    }
                }

                public boolean isUnsubscribed() {
                    return this.subs.isUnsubscribed();
                }

                public void unsubscribe() {
                    this.subs.unsubscribe();
                }

                public void set(Subscription s) {
                    this.subs.set(s);
                }
            }
            DualAction executeOnce = new DualAction();
            this.tracking.add((Subscription)executeOnce);
            Timeline timer = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)delay), (EventHandler)executeOnce, new KeyValue[0])});
            executeOnce.setTimer(timer);
            timer.play();
            executeOnce.set(Subscriptions.create(() -> {
                timer.stop();
                this.tracking.remove((Subscription)executeOnce);
            }));
            return executeOnce;
        }

        public Subscription schedule(Action0 action) {
            BooleanSubscription s = BooleanSubscription.create();
            Runnable runnable = () -> {
                try {
                    if (this.tracking.isUnsubscribed() || s.isUnsubscribed()) {
                        return;
                    }
                    action.call();
                }
                finally {
                    this.tracking.remove((Subscription)s);
                }
            };
            this.tracking.add((Subscription)s);
            if (Platform.isFxApplicationThread()) {
                if (this.trampoline(runnable)) {
                    return Subscriptions.unsubscribed();
                }
            } else {
                this.queue.offer(runnable);
                Platform.runLater((Runnable)this);
            }
            return Subscriptions.create(() -> this.tracking.remove((Subscription)s));
        }

        boolean trampoline(Runnable runnable) {
            if (this.wip == 0) {
                this.wip = 1;
                runnable.run();
                if (--this.wip > 0) {
                    do {
                        Runnable r = this.queue.poll();
                        r.run();
                    } while (--this.wip > 0);
                }
                return true;
            }
            this.queue.offer(runnable);
            this.run();
            return false;
        }

        @Override
        public void run() {
            if (this.wip++ == 0) {
                do {
                    Runnable r = this.queue.poll();
                    r.run();
                } while (--this.wip > 0);
            }
        }
    }
}

