/*
 * Decompiled with CFR 0.152.
 */
package rx.subscribers;

import com.sun.javafx.binding.ExpressionHelper;
import javafx.beans.InvalidationListener;
import javafx.beans.binding.Binding;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Action1;

final class BindingSubscriber<T>
extends Subscriber<T>
implements ObservableValue<T>,
Binding<T> {
    private final Observable<T> observable;
    private final Action1<Throwable> onError;
    private Subscription subscription;
    private ExpressionHelper<T> helper;
    private T value;

    private BindingSubscriber(Observable<T> observable, Action1<Throwable> onError) {
        this.observable = observable;
        this.onError = onError;
    }

    public static <T> BindingSubscriber<T> forObservable(Observable<T> observable, Action1<Throwable> onError, boolean isLazy) {
        BindingSubscriber<T> bindingSubscriber = new BindingSubscriber<T>(observable, onError);
        if (!isLazy) {
            super.connect();
        }
        return bindingSubscriber;
    }

    private void connect() {
        this.subscription = this.observable.subscribe((Subscriber)this);
    }

    public void onCompleted() {
    }

    public void onError(Throwable e) {
        this.onError.call((Object)e);
    }

    public void onNext(T t) {
        this.value = t;
        this.fireValueChangedEvent();
    }

    public T getValue() {
        if (this.subscription == null) {
            this.connect();
        }
        return this.value;
    }

    public boolean isValid() {
        return true;
    }

    public void invalidate() {
    }

    public ObservableList<?> getDependencies() {
        throw new UnsupportedOperationException();
    }

    public void dispose() {
        if (this.subscription != null) {
            this.subscription.unsubscribe();
        }
        this.unsubscribe();
    }

    public void addListener(InvalidationListener listener) {
        this.helper = ExpressionHelper.addListener(this.helper, (ObservableValue)this, (InvalidationListener)listener);
    }

    public void addListener(ChangeListener<? super T> listener) {
        this.helper = ExpressionHelper.addListener(this.helper, (ObservableValue)this, listener);
    }

    public void removeListener(InvalidationListener listener) {
        this.helper = ExpressionHelper.removeListener(this.helper, (InvalidationListener)listener);
    }

    public void removeListener(ChangeListener<? super T> listener) {
        this.helper = ExpressionHelper.removeListener(this.helper, listener);
    }

    protected void fireValueChangedEvent() {
        ExpressionHelper.fireValueChangedEvent(this.helper);
    }
}

