/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.loadbalance;

import io.rsocket.loadbalance.FrugalQuantile;

class Median
extends FrugalQuantile {
    public Median() {
        super(0.5, 1.0);
    }

    public synchronized void reset() {
        super.reset(0.5);
    }

    @Override
    public synchronized void insert(double x) {
        if (this.sign == 0) {
            this.estimate = x;
            this.sign = 1;
        } else {
            double estimate = this.estimate;
            if (x > estimate) {
                this.greaterThanZero(x);
            } else if (x < estimate) {
                this.lessThanZero(x);
            }
        }
    }

    private void greaterThanZero(double x) {
        double estimate = this.estimate;
        this.step += this.sign;
        estimate = this.step > 0 ? (estimate += (double)this.step) : (estimate += 1.0);
        if (estimate > x) {
            this.step = (int)((double)this.step + (x - estimate));
            estimate = x;
        }
        if (this.sign < 0) {
            this.step = 1;
        }
        this.sign = 1;
        this.estimate = estimate;
    }

    private void lessThanZero(double x) {
        double estimate = this.estimate;
        this.step -= this.sign;
        estimate = this.step > 0 ? (estimate -= (double)this.step) : (estimate -= 1.0);
        if (estimate < x) {
            this.step = (int)((double)this.step + (estimate - x));
            estimate = x;
        }
        if (this.sign > 0) {
            this.step = 1;
        }
        this.sign = -1;
        this.estimate = estimate;
    }

    @Override
    public String toString() {
        return "Median(v=" + this.estimate + ")";
    }
}

