/*
 * Decompiled with CFR 0.152.
 */
package io.seventytwo.vaadinjooq.repository;

import com.vaadin.flow.data.provider.SortDirection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.SelectConditionStep;
import org.jooq.SelectSeekStepN;
import org.jooq.Table;
import org.jooq.impl.DSL;

public class JooqRepository {
    private final DSLContext dslContext;

    public JooqRepository(DSLContext dslContext) {
        this.dslContext = dslContext;
    }

    public <T extends Record> List<T> findAll(Table<T> table, Condition condition, Map<Field<?>, SortDirection> orderBy, int offset, int limit) {
        SelectConditionStep where = condition == null ? this.dslContext.selectFrom(table).where(DSL.noCondition()) : this.dslContext.selectFrom(table).where(condition);
        if (orderBy != null && !orderBy.isEmpty()) {
            return this.createOrderBy(table, where, orderBy).offset((Number)offset).limit((Number)limit).fetch();
        }
        return where.offset((Number)offset).limit((Number)limit).fetch();
    }

    public <T extends Record> int count(Table<T> table, Condition condition) {
        if (condition == null) {
            return (Integer)this.dslContext.selectCount().from(table).fetchOneInto(Integer.class);
        }
        return (Integer)this.dslContext.selectCount().from(table).where(condition).fetchOneInto(Integer.class);
    }

    private <T extends Record> SelectSeekStepN<T> createOrderBy(Table<T> table, SelectConditionStep<T> where, Map<Field<?>, SortDirection> orderColumns) {
        ArrayList orderFields = new ArrayList();
        orderColumns.forEach((key, value) -> {
            ArrayList<String> qualifiers = new ArrayList<String>();
            qualifiers.add(table.getSchema().getName());
            qualifiers.addAll(Arrays.asList(table.getQualifiedName().getName()));
            qualifiers.add(key.getName());
            Name column = DSL.name(qualifiers);
            Field field = DSL.field((Name)column);
            orderFields.add(value == SortDirection.ASCENDING ? field.asc() : field.desc());
        });
        return where.orderBy(orderFields);
    }
}

