/*
 * Decompiled with CFR 0.152.
 */
package io.seventytwo.vaadinjooq.util;

import com.vaadin.flow.data.provider.QuerySortOrder;
import com.vaadin.flow.data.provider.SortDirection;
import java.util.List;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Table;

public class JooqUtil {
    private JooqUtil() {
    }

    public static String getPropertyName(Field<?> field) {
        String fieldName = field.getName();
        char[] chars = fieldName.toLowerCase().toCharArray();
        boolean wasUnderScore = false;
        StringBuilder sb = new StringBuilder();
        for (char c : chars) {
            if (c == '_') {
                wasUnderScore = true;
                continue;
            }
            if (wasUnderScore) {
                sb.append(Character.toString(c).toUpperCase());
            } else {
                sb.append(c);
            }
            wasUnderScore = false;
        }
        return sb.toString();
    }

    public static String getHeaderText(Field<?> field) {
        String fieldName = field.getName();
        char[] chars = fieldName.toLowerCase().toCharArray();
        boolean wasUnderScore = false;
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (char c : chars) {
            if (c == '_') {
                wasUnderScore = true;
                sb.append(" ");
                continue;
            }
            if (wasUnderScore) {
                sb.append(Character.toString(c).toUpperCase());
            } else if (first) {
                sb.append(Character.toString(c).toUpperCase());
                first = false;
            } else {
                sb.append(c);
            }
            wasUnderScore = false;
        }
        return sb.toString();
    }

    public static Field<?> getField(Table<?> table, String propertyName) {
        String fieldName = JooqUtil.getFieldName(propertyName);
        return table.field(fieldName);
    }

    public static OrderField<?>[] createOrderBy(Table<?> table, List<QuerySortOrder> sortOrders) {
        return (OrderField[])sortOrders.stream().map(sortOrder -> {
            Field field = table.field(JooqUtil.getFieldName((String)sortOrder.getSorted()));
            return sortOrder.getDirection() == SortDirection.ASCENDING ? field.asc() : field.desc();
        }).toArray(OrderField[]::new);
    }

    private static String getFieldName(String propertyName) {
        StringBuilder sb = new StringBuilder();
        for (char c : propertyName.toCharArray()) {
            if (Character.isUpperCase(c)) {
                sb.append("_").append(c);
                continue;
            }
            sb.append(c);
        }
        return sb.toString().toUpperCase();
    }
}

