/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.ref;

import io.smallrye.common.constraint.Assert;
import io.smallrye.common.ref.CleanerReference;
import io.smallrye.common.ref.PhantomReference;
import io.smallrye.common.ref.Reapable;
import io.smallrye.common.ref.Reaper;
import io.smallrye.common.ref.Reference;
import io.smallrye.common.ref.SoftReference;
import io.smallrye.common.ref.StrongReference;
import io.smallrye.common.ref.WeakReference;
import java.lang.ref.ReferenceQueue;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.atomic.AtomicInteger;

public final class References {
    private static final Reference<?, ?> NULL = new StrongReference(null);

    private References() {
    }

    public static <T, A> Reference<T, A> create(Reference.Type type, T value, A attachment, Reaper<T, A> reaper) {
        Assert.checkNotNullParam((String)"type", (Object)((Object)type));
        if (value == null) {
            type = Reference.Type.NULL;
        }
        switch (type) {
            case STRONG: {
                return new StrongReference<T, A>(value, attachment);
            }
            case WEAK: {
                return new WeakReference<T, A>(value, attachment, reaper);
            }
            case PHANTOM: {
                return new PhantomReference<T, A>(value, attachment, reaper);
            }
            case SOFT: {
                return new SoftReference<T, A>(value, attachment, reaper);
            }
            case NULL: {
                return attachment == null ? References.getNullReference() : new StrongReference<Object, A>(null, attachment);
            }
        }
        throw Assert.impossibleSwitchCase((Object)((Object)type));
    }

    public static <T, A> Reference<T, A> create(Reference.Type type, T value, A attachment, ReferenceQueue<? super T> referenceQueue) {
        Assert.checkNotNullParam((String)"type", (Object)((Object)type));
        if (referenceQueue == null) {
            return References.create(type, value, attachment);
        }
        if (value == null) {
            type = Reference.Type.NULL;
        }
        switch (type) {
            case STRONG: {
                return new StrongReference<T, A>(value, attachment);
            }
            case WEAK: {
                return new WeakReference<T, A>(value, attachment, referenceQueue);
            }
            case PHANTOM: {
                return new PhantomReference<T, A>(value, attachment, referenceQueue);
            }
            case SOFT: {
                return new SoftReference<T, A>(value, attachment, referenceQueue);
            }
            case NULL: {
                return attachment == null ? References.getNullReference() : new StrongReference<Object, A>(null, attachment);
            }
        }
        throw Assert.impossibleSwitchCase((Object)((Object)type));
    }

    public static <T, A> Reference<T, A> create(Reference.Type type, T value, A attachment) {
        Assert.checkNotNullParam((String)"type", (Object)((Object)type));
        if (value == null) {
            type = Reference.Type.NULL;
        }
        switch (type) {
            case STRONG: {
                return new StrongReference<T, A>(value, attachment);
            }
            case WEAK: {
                return new WeakReference<T, A>(value, attachment);
            }
            case SOFT: {
                return new SoftReference<T, A>(value, attachment);
            }
            case PHANTOM: 
            case NULL: {
                return attachment == null ? References.getNullReference() : new StrongReference<Object, A>(null, attachment);
            }
        }
        throw Assert.impossibleSwitchCase((Object)((Object)type));
    }

    public static <T, A> Reference<T, A> getNullReference() {
        return NULL;
    }

    static final class ReaperThread
    extends Thread {
        static final ReferenceQueue<Object> REAPER_QUEUE = new ReferenceQueue();

        ReaperThread() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        java.lang.ref.Reference<Object> ref;
                        if ((ref = REAPER_QUEUE.remove()) instanceof CleanerReference) {
                            ((CleanerReference)ref).clean();
                        }
                        if (!(ref instanceof Reapable)) continue;
                        ReaperThread.reap((Reapable)((Object)ref));
                    }
                }
                catch (InterruptedException interruptedException) {}
                finally {
                    continue;
                }
                break;
            }
        }

        private static <T, A> void reap(Reapable<T, A> reapable) {
            reapable.getReaper().reap((Reference)((Object)reapable));
        }

        static {
            AtomicInteger cnt = new AtomicInteger(1);
            PrivilegedAction<Void> action = () -> {
                ReaperThread thr = new ReaperThread();
                thr.setName("Reference Reaper #" + cnt.getAndIncrement());
                thr.setDaemon(true);
                thr.start();
                return null;
            };
            for (int i = 0; i < 3; ++i) {
                AccessController.doPrivileged(action);
            }
        }
    }
}

