/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.groups.UniOnItemDelay;
import io.smallrye.mutiny.groups.UniOnItemIgnore;
import io.smallrye.mutiny.groups.UniOnNotNull;
import io.smallrye.mutiny.groups.UniOnNull;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.uni.UniOnItemConsume;
import io.smallrye.mutiny.operators.uni.UniOnItemTransform;
import io.smallrye.mutiny.operators.uni.UniOnItemTransformToMulti;
import io.smallrye.mutiny.operators.uni.UniOnItemTransformToUni;
import io.smallrye.mutiny.subscription.UniEmitter;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;

public class UniOnItem<T> {
    private final Uni<T> upstream;

    public UniOnItem(Uni<T> upstream) {
        this.upstream = ParameterValidation.nonNull(upstream, "upstream");
    }

    public Uni<T> invoke(Consumer<? super T> callback) {
        Consumer<? super T> actual = Infrastructure.decorate(ParameterValidation.nonNull(callback, "callback"));
        return Infrastructure.onUniCreation(new UniOnItemConsume<T>(this.upstream, actual, null, null));
    }

    public Uni<T> invoke(Runnable callback) {
        Runnable actual = ParameterValidation.nonNull(callback, "callback");
        return this.invoke((? super T ignored) -> actual.run());
    }

    @Deprecated
    public Uni<T> invokeUni(Function<? super T, Uni<?>> action) {
        return this.call(action);
    }

    public Uni<T> call(Function<? super T, Uni<?>> action) {
        Function actual = Infrastructure.decorate(ParameterValidation.nonNull(action, "action"));
        return this.transformToUni((? super T item) -> {
            Uni uni = Objects.requireNonNull((Uni)actual.apply(item), "The callback produced a `null` uni");
            return uni.onItem().transform(ignored -> item);
        });
    }

    public Uni<T> call(Supplier<Uni<?>> action) {
        Supplier<Uni<?>> actual = Infrastructure.decorate(ParameterValidation.nonNull(action, "action"));
        return this.call((? super T ignored) -> (Uni)actual.get());
    }

    @Deprecated
    public <R> Uni<R> apply(Function<? super T, ? extends R> mapper) {
        return this.transform(mapper);
    }

    public <R> Uni<R> transform(Function<? super T, ? extends R> mapper) {
        Function<? super T, ? extends R> actual = Infrastructure.decorate(ParameterValidation.nonNull(mapper, "mapper"));
        return Infrastructure.onUniCreation(new UniOnItemTransform<T, R>(this.upstream, actual));
    }

    public <R> Uni<R> transformToUni(Function<? super T, Uni<? extends R>> mapper) {
        Function<? super T, Uni<? extends R>> actual = Infrastructure.decorate(ParameterValidation.nonNull(mapper, "mapper"));
        return Infrastructure.onUniCreation(new UniOnItemTransformToUni<T, R>(this.upstream, actual));
    }

    @Deprecated
    public <R> Uni<R> produceUni(Function<? super T, Uni<? extends R>> mapper) {
        return this.transformToUni(mapper);
    }

    public <R> Multi<R> transformToMulti(Function<? super T, ? extends Publisher<? extends R>> mapper) {
        Function<? super T, ? extends Publisher<? extends R>> actual = Infrastructure.decorate(ParameterValidation.nonNull(mapper, "mapper"));
        return Infrastructure.onMultiCreation(new UniOnItemTransformToMulti(this.upstream, actual));
    }

    @Deprecated
    public <R> Multi<R> produceMulti(Function<? super T, ? extends Publisher<? extends R>> mapper) {
        return this.transformToMulti(mapper);
    }

    @Deprecated
    public <R> Uni<R> produceCompletionStage(Function<? super T, ? extends CompletionStage<? extends R>> mapper) {
        Function actual = Infrastructure.decorate(ParameterValidation.nonNull(mapper, "mapper"));
        return this.transformToUni((? super T item) -> {
            CompletionStage stage = Objects.requireNonNull((CompletionStage)actual.apply(item), "The mapper produces a `null` completion stage");
            return Uni.createFrom().completionStage(stage);
        });
    }

    public <R> Uni<R> transformToUni(BiConsumer<? super T, UniEmitter<? super R>> consumer) {
        BiConsumer actual = Infrastructure.decorate(ParameterValidation.nonNull(consumer, "consumer"));
        return this.transformToUni((? super T it) -> Uni.createFrom().emitter(emitter -> actual.accept((Object)it, (UniEmitter)emitter)));
    }

    @Deprecated
    public <R> Uni<R> produceUni(BiConsumer<? super T, UniEmitter<? super R>> consumer) {
        return this.transformToUni(consumer);
    }

    public UniOnItemDelay<T> delayIt() {
        return new UniOnItemDelay<T>(this.upstream, null);
    }

    public UniOnItemIgnore<T> ignore() {
        return new UniOnItemIgnore(this);
    }

    public Uni<T> failWith(Function<? super T, ? extends Throwable> mapper) {
        Function actual = Infrastructure.decorate(ParameterValidation.nonNull(mapper, "mapper"));
        return Infrastructure.onUniCreation(this.transformToUni((? super T t) -> {
            Throwable failure = Objects.requireNonNull((Throwable)actual.apply(t), "The mapper returned `null`");
            return Uni.createFrom().failure(failure);
        }));
    }

    public Uni<T> failWith(Supplier<? extends Throwable> supplier) {
        Supplier<? extends Throwable> actual = Infrastructure.decorate(ParameterValidation.nonNull(supplier, "supplier"));
        return Infrastructure.onUniCreation(this.transformToUni((? super T ignored) -> {
            Throwable failure = Objects.requireNonNull((Throwable)actual.get(), "The supplier returned `null`");
            return Uni.createFrom().failure(failure);
        }));
    }

    public <O> Uni<O> castTo(Class<O> target) {
        ParameterValidation.nonNull(target, "target");
        return this.apply(target::cast);
    }

    public UniOnNull<T> ifNull() {
        return new UniOnNull<T>(this.upstream);
    }

    public UniOnNotNull<T> ifNotNull() {
        return new UniOnNotNull<T>(this.upstream);
    }

    public <O> Multi<O> disjoint() {
        return this.upstream.toMulti().onItem().disjoint();
    }
}

